/*
 * ZoneMinder User Class Interface, $Date: 2005/01/31 12:07:38 $, $Revision: 1.2 $
 * Copyright (C) 2003  Philip Coombes
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/  

#include "zm.h"
#include "zm_db.h"

#ifndef ZM_USER_H
#define ZM_USER_H

#if HAVE_LIBCRYPTO
#include <openssl/md5.h>
#endif // HAVE_LIBCRYPTO

class User
{
public:
	typedef enum { PERM_NONE=1, PERM_VIEW, PERM_EDIT } Permission;

protected:
	char username[32+1];
	char password[64+1];
	bool enabled;
	Permission stream;
	Permission events;
	Permission monitors;
	Permission system;
	int *monitor_ids;

public:
	User();
	User( MYSQL_ROW &dbrow );
	~User();

	const char *getUsername() const { return( username ); }
	const char *getPassword() const { return( password ); }
	bool isEnabled() const { return( enabled ); }
	Permission getStream() const { return( stream ); }
	Permission getEvents() const { return( events ); }
	Permission getMonitors() const { return( monitors ); }
	Permission getSystem() const { return( system ); }
	bool canAccess( int monitor_id );
};

User *zmLoadUser( const char *username, const char *password );
User *zmLoadAuthUser( const char *auth, bool use_remote_addr=true );

#endif // ZM_USER_H
