/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "smsreceiver.h"

namespace SMSManager {

	SMSReceiver::SMSReceiver(const SMSDeviceConfig& dev, QObject *parent, const char *name)
	: QObject(parent, name), dev_cfg(dev), flag_stop(false), flag_stop_wanted(false)
	{
		DB_MSG_D("deamon created");
		deamon = new QProcess(this);
		connect( deamon, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
		connect( deamon, SIGNAL(readyReadStderr()), this, SLOT(readFromStderr()) );
		connect( deamon, SIGNAL(processExited()), this, SLOT(processExited()) );
	}
	
	void SMSReceiver::readFromStdout()
	{
		QString str( deamon->readStdout() );
		
		DB_MSG_D("deamon stdout [" <<  str << "]");
		
		if( QRegExp(MESSAGE_PATTERN, false, true).exactMatch( str ) )
			emit incomingSMS( createSMSMessage( str ) );
	}
	
	void SMSReceiver::readFromStderr()
	{
		QString str( deamon->readStderr() );
		 
		emit deamonError( tr("Le dmon de rception des messages a renvoy l'erreur suivante :\n") + str );
							
		DB_MSG_D("deamon stderr [" <<  str << "]");
	}
	
	void SMSReceiver::processExited()
	{
		flag_stop = true;
		
		emit stopped();	
		if(!flag_stop_wanted)
			emit deamonError( tr("Le dmon de rception des messages s'est arrt prmaturment !") );
					
		flag_stop_wanted = false;
		DB_MSG_D("deamon stopped");
	}
	
	bool SMSReceiver::isRunning()
	{
		return deamon->isRunning();
	}
	
	SMSMessage SMSReceiver::createSMSMessage(const QString& str)
	{
		SMSMessage sms;
		QStringList lines = QStringList::split('\n', str);
		SMSContact exp;
		
		for(QStringList::Iterator it = lines.begin(); it != lines.end(); it++)
		{
			int pos = (*it).find(':');
			if( pos > -1)
			{
				QString header = (*it).left( pos ).stripWhiteSpace();
				QString value = (*it).mid( ++pos ).stripWhiteSpace();
				
				if(header == SMSH_MESSAGE_TYPE)
					sms.setType( value );

				if(header == SMSH_SENDER)
					exp.Address = value.mid(1, value.length() - 2);
					
				if(header == SMSH_DATA_DATA)
					sms.setMessage( value.mid(1, value.length() - 2) );
				
			}
		}
		sms.setFrom( exp );
		sms.setSubject( "SMS" );
		sms.setDate( QDateTime::currentDateTime() );
		
		return sms;
	}
	
	SMSReceiver::~SMSReceiver()
	{
		DB_MSG_D("destructing deamon");
		
	 	if(deamon->isRunning())
			stop();
			
		DB_MSG_D("deamon destructed");
	}
	
	bool SMSReceiver::start()
	{
		deamon->addArgument( "gsmsmsd" );

		dev_cfg.appendArguments(deamon, true, true);
		
		deamon->addArgument( "sms" );
		deamon->addArgument( "no_cb" );
		deamon->addArgument( "no_stat" );
		
		DB_MSG_D("deamon started");
		
		return deamon->start();
	}
	void SMSReceiver::timeOut()
	{
		flag_stop = true;
		DB_MSG_D("deamon timeout");
	}
	
	void SMSReceiver::stop()
	{
		DB_MSG_D("init stop deamon");
		flag_stop = false;
		flag_stop_wanted = true;
        	
		DB_MSG_D("try terminate deamon");
		
		deamon->tryTerminate();
        	
		QTimer::singleShot( 3000, deamon, SLOT( kill() ) );
		QTimer::singleShot( 5000, this, SLOT( timeOut() ) );	
		
		while(!flag_stop)
			current_app->processEvents();
		DB_MSG_D("deamon r. stopped");
	}
	
	
    	
};
