/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "smsmessage.h"

namespace SMSManager {

	SMSMessage::SMSMessage()
	 : strSubject("SMS"), strMessage(QSTRING_EMPTY), strPDU(QSTRING_EMPTY),
	   strType(QSTRING_EMPTY), dtDate( QDateTime::currentDateTime() )
	{
	}
	
	SMSMessage::SMSMessage(const SMSMessage& sms)
	{
		strSubject = sms.strSubject;
		strMessage = sms.strMessage;
		scFrom = sms.scFrom;
		scTo = sms.scTo;
		strPDU = sms.strPDU;
		dtDate = sms.dtDate;
		strType=sms.strType;
	}
	
	SMSMessage::~SMSMessage()
	{
	}

	QString SMSMessage::convNum(const QString& num) const
	{
		QString strType("81");
		QString strOut(""), strNum(num);
		if (strNum.length() > 3 )
		{
			if( strNum.left(3) == "+00" )
			{
				strNum = num.mid(3);
				strType = "91";
			}
			if( strNum.left(2) == "00" )
			{
				strNum = num.mid(2);
				strType = "91";
			}
			if( strNum.left(1) == "+" )
			{
				strNum = num.mid(1);
				strType = "91";
			}
		}

		strOut = (QString("00") + QString::number( strNum.length(), 16)).right(2)
			 + strType;
		
		strNum += QString("F");
		
		for(unsigned int i = 0; i < strNum.length() - 1; i = i + 2)
			strOut += strNum.mid(i + 1, 1) + strNum.mid(i, 1);
			
		return strOut;
	}
	
	QString SMSMessage::toBin7(const char& nb) const
	{
		return (QString("0000000") + QString::number( nb, 2 )).right(7);
	}
	
	QString SMSMessage::bin2Hex(const QString& nb) const
	{
		return (QString("00") + QString::number( nb.toInt(NULL, 2), 16 )).right(2);
	}

	QString SMSMessage::encode2PDU(const QString& num, const QString& txt) const
	{
		return  (QString("001100") + convNum(num) +
			QString("000064") + convTxtPDU(txt)).upper();
	}
	
	QString SMSMessage::convTxtPDU(const QString& txt) const
	{

		QString dbin(""), strOut, strTxt(txt);
		int txt_length = strTxt.length();
		
		if(txt_length > 160)
		{
			strTxt = strTxt.left(160);
			txt_length = 160;
		}
		
		strOut = (QString("00") + QString::number( txt_length, 16)).right(2);
		
		for(int i = 0; i < txt_length; i++)
			dbin = toBin7( (strTxt.mid(i, 1).latin1())[0] ) + dbin;
			
		while(dbin.length() > 8)
		{
			strOut += bin2Hex( dbin.right(8) );
			dbin = dbin.mid(0, dbin.length() - 8);
		}
    
		return strOut + bin2Hex( dbin );
	}
	
	bool SMSMessage::sendSMS(const SMSDeviceConfig& cfg)
	{
		switch(cfg.library)
		{
		case ssNative:
			/*QFile file( dev );
			if ( file.open( IO_ReadWrite  ) )
			{
				QTextStream stream( &file );
				stream << "atE0" << '\r';
				std::cout << stream.read() << std::endl;
				stream << "AT+CMGF=0" << '\r';
				stream << "AT+CMGS=" << pdu.length() / 2 << '\r';
				stream << pdu << char(26);
			}
			file.close();
			
			
			//echo off
			std::cout << dev	 				<< std::endl; //wait OK
			std::cout << "atE0" << '\r' 				<< std::endl; //wait OK
			//PDU mode
			std::cout << "AT+CMGF=0" << '\r' 			<< std::endl; //wait OK
			std::cout << "AT+CMGS=" << pdu.length() / 2 << '\r' 	<< std::endl; //wait >
			std::cout << pdu << char(26) 				<< std::endl; //wait OK*/
			break;
		case ssGSMlib:
			QProcessSync send_sms(0);
			
			send_sms.addArgument( "gsmsendsms" );
			
			cfg.appendArguments(&send_sms, false, true);
			
			send_sms.addArgument( scTo.Address );
			send_sms.addArgument( strMessage );
			
			return send_sms.startSync();
			
			break;
		}
		return false;
	}

	SMSMessage SMSMessage::fromString(const QString& str, bool isFMAFormat)
	{
	
		SMSMessage sms;
		if( str.length() > 3 && str.find( FMA_SEP ) > -1 )
		{
			QStringList lstStr = QStringList::split( FMA_SEP, str.mid( 1, str.length() - 2 ), true );
			if( lstStr.count() >= (isFMAFormat ? 12 : 10) )
			{
				QStringList::Iterator it = lstStr.begin();
				sms.strSubject = QSTRING_CHECK_NULL(*it); it++;
				sms.strMessage = QSTRING_CHECK_NULL(*it); it++;
				
				sms.scFrom.Name = QSTRING_CHECK_NULL(*it); it++;
				sms.scFrom.Address = QSTRING_CHECK_NULL(*it); it++;
				sms.scFrom.PType = QSTRING_CHECK_NULL(*it); it++;
				
				if(isFMAFormat)
					it++;
				
				sms.scTo.Name = QSTRING_CHECK_NULL(*it); it++;
				sms.scTo.Address = QSTRING_CHECK_NULL(*it) ; it++;
				sms.scTo.PType = QSTRING_CHECK_NULL(*it); it++;
				
				if(sms.scTo.Address.isNull())
					DB_MSG("ERREUR !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
				
				/* Convertion de date -  optimiser */
				//Format : dd/mm/yyyy hh:mm:ss
				QString str_date( QSTRING_CHECK_NULL(*it) );
				sms.dtDate = QDateTime( QDate( str_date.mid(6, 4).toInt(),
							       str_date.mid(3, 2).toInt(),
							       str_date.mid(0, 2).toInt()
							     ),
						    	QTime::fromString( str_date.mid(11, 8) )
						      ); it++;
						   
				/* Fin convertion */
				
				if(isFMAFormat)
				{
					it++;
					sms.strPDU = QSTRING_CHECK_NULL(*it);
				}
				else
					sms.strPDU = QSTRING_CHECK_NULL(*it);
			}
		}
		return sms;
	}

	QString SMSMessage::toStringHTML() const
	{
		return QString("<b>Date/Heure : </b> %1<br>"
			       "<b>De (nom) : </b> %2<br>"
			       "<b>De (numro) : </b> %3<hr>%4").arg(
			       				dtDate.toString("dddd dd MMMM yyyy  hh:mm:ss"))
								.arg( scFrom.Name.isEmpty() ?
											"Inconnu" : scFrom.Name )
								.arg(scFrom.Address)
								.arg(strMessage);
	}
 	/* Proprits */
	
	QString SMSMessage::type() const
	{
		return strType;
	}
	
	void SMSMessage::setType(const QString& str)
	{
		strType = str;
	}

	QDateTime SMSMessage::date() const
	{
		return dtDate;
	}
	void SMSMessage::setDate(const QDateTime& dt)
	{
		dtDate = dt;
	}
	
	QString SMSMessage::subject() const
	{
		return strSubject;
	}
	void SMSMessage::setSubject(const QString& str)
	{
		strSubject = str;
	}
	
	QString SMSMessage::message() const
	{
		return strMessage;
	}
	void SMSMessage::setMessage(const QString& str)
	{
		strMessage = str;
		strPDU = "";
	}
	
	SMSContact SMSMessage::from() const
	{
		return scFrom;
	}
	void SMSMessage::setFrom(const SMSContact& sc)
	{
		scFrom = sc;
		strPDU = "";
	}
	
	SMSContact SMSMessage::to() const
	{
		return scTo;
	}
	void SMSMessage::setTo(const SMSContact& sc)
	{
		strPDU = "";
		scTo = sc;
	}
	
	QString SMSMessage::PDU()
	{
		if( strPDU.isEmpty() )
			strPDU = encode2PDU( scTo.Address, strMessage );
		
		return strPDU;
	}
	void SMSMessage::setPDU(const QString& str)
	{
		strPDU = str;
	}
	
	/* Fin proprits */
};
