/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "qprocesssync.h"

QProcessSync::QProcessSync(QObject *parent, const char *name)
 : QProcess(parent, name), _stdOut(QSTRING_EMPTY), _stdErr(QSTRING_EMPTY)
{
	connect( this, SIGNAL(processExited()), this, SLOT(start_finished()) );
	connect( this, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
	connect( this, SIGNAL(readyReadStderr()), this, SLOT(readFromStderr()) );
}


QProcessSync::~QProcessSync()
{
}

void QProcessSync::start_finished()
{
	flag_start_finished = true;
}

bool QProcessSync::startSync( QStringList * env )
{
	_stdOut = QSTRING_EMPTY;
	_stdErr = QSTRING_EMPTY;
	
	flag_start_finished = false;
	bool ret = QProcess::start(env);
	
	while(!flag_start_finished)
		current_app->processEvents();
	
	return ret;
}

void QProcessSync::readFromStdout()
{
	_stdOut += QString( this->readStdout() );
}

void QProcessSync::readFromStderr()
{
	_stdErr += QString( this->readStderr() );
}

QString QProcessSync::getStdOut() const
{
	return _stdOut;
}

QString QProcessSync::getStdErr() const
{
	return _stdErr;
}
