/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "boxfile.h"

BoxFile::BoxFile()
{
}

BoxFile::~BoxFile()
{
	clear();
}

BoxFile::BoxFile(const BoxFile&)
{
}

void BoxFile::clear()
{
	opened_file = QSTRING_EMPTY;
	mess_list.clear();
}

void BoxFile::refreshFromFile(const QString& filename, bool isFMAFile)
{
	clear();
	opened_file = filename;
	QFile file( filename );

	if ( file.open( IO_ReadOnly ) )
	{
		QTextStream stream( &file );
		
		if(isFMAFile)
			stream.readLine(); //csv header
		
		while ( !stream.atEnd() )
		{
			QString line( stream.readLine().stripWhiteSpace() );
			if( line.length() > 5 )
				mess_list.push_back( SMSManager::SMSMessage::fromString( line , isFMAFile ) );

		}
	}
	file.close();
}

void BoxFile::saveToFile(const QString& path) const
{
	QFile file( QString(path.isEmpty() ? opened_file : path)  );
	DB_MSG_B(file.name());
	if ( file.open( IO_WriteOnly ) )
	{
		DB_MSG_B("file opened");
		QTextStream stream( &file );
		DB_MSG_B("size" << mess_list.size());
		for(unsigned int i = 0; i < mess_list.size(); i++)
		{
			SMSManager::SMSMessage mess(mess_list.at(i));
			stream  << ADD_QUOTE(mess.subject()) << ','
				<< ADD_QUOTE(mess.message()) << ','
				<< ADD_QUOTE(mess.from().Name) << ','
				<< ADD_QUOTE(mess.from().Address) << ','
				<< ADD_QUOTE(mess.from().PType) << ','
				<< ADD_QUOTE(mess.to().Name) << ','
				<< ADD_QUOTE(mess.to().Address) << ','
				<< ADD_QUOTE(mess.to().PType) << ','
				<< ADD_QUOTE(mess.date().toString( "dd/MM/yyyy hh:mm:ss" )) << ','
				<< ADD_QUOTE(mess.PDU())
				<< "\n";
		}
	}
	file.close();	
	DB_MSG_B("file closed");
}

int BoxFile::messagesCount() const
{
	return mess_list.size();
}

SMSManager::SMSMessage BoxFile::message(int index) const
{
	return mess_list.at(index);
}

void BoxFile::setMessage(int index, SMSManager::SMSMessage sms)
{
	mess_list.at(index) = sms;
}

void BoxFile::addMessage(const SMSManager::SMSMessage& sms)
{
	mess_list.push_back( sms );
}

void BoxFile::addMessages(const BoxFile&)
{
	DB_NI("addMessages(const BoxFile&)");
}

void BoxFile::removeMessage(int index)
{
	mess_list.erase( SMSManager::SMSMessageList::iterator(mess_list.begin() + index) );
}

void BoxFile::removeAll()
{
	mess_list.clear();
}
