/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
 
#include "appsettings.h"

AppSettings::AppSettings()
{
	QDir path;
	cfg_path = CFG_DIRNAME;
	if( !QFile::exists(cfg_path) )
		DB_MSG(path.mkdir(cfg_path));

	createBoxFile("inbox");
	createBoxFile("outbox");
	createBoxFile("sentbox");
	createBoxFile("draft");
	createBoxFile("bin");

	createPhoneBookFile();

	loadSettings();
}


AppSettings::~AppSettings()
{
}

void AppSettings::loadSettings()
{
	QSettings settings;
	settings.setPath( "NGSoft", "SMSManager" );
	
	start_min = settings.readBoolEntry( "/general/start_min", false );
	auto_start_deamon = settings.readBoolEntry( "/general/auto_start_deamon", false );
	contact_pattern = settings.readEntry( "/general/contact_pattern", PREF_CT_PATTERN3 );
	contact_local.Name = settings.readEntry( "/general/contact_local_name", QSTRING_EMPTY );
	contact_local.Address = settings.readEntry( "/general/contact_local_address", QSTRING_EMPTY );
	show_deamon_error =  settings.readBoolEntry( "/general/show_deamon_error", true );
	prefix_num =  settings.readBoolEntry( "/general/prefix_num", true );
	
	show_popup = settings.readBoolEntry( "/popup/show_popup", true );
	popup_pixmap_path = settings.readEntry( "/popup/popup_img", PREF_DEFAULT_IMG );
	
	popup_pixmap = QPixmap::fromMimeSource( popup_pixmap_path );
	popup_sound = settings.readEntry( "/popup/popup_snd", PREF_DEFAULT_SND );

	dev_config = SMSManager::SMSDeviceConfig(
			settings.readEntry( "/devices/dev1", QString("/dev/rfcomm0") ) ,
			settings.readEntry( "/devices/dev2", QString("/dev/rfcomm1") ) ,
			settings.readEntry( "/devices/bauds", QString("38400") ) ,
			settings.readEntry( "/devices/init", QSTRING_EMPTY ) ,
			settings.readEntry( "/devices/sca", QSTRING_EMPTY ) ,
			settings.readBoolEntry( "/devices/xonxoff", false )
						);
	    
	rm_phonebook = settings.readEntry( "/devices/phonebook", QString("SM") );
	
}

void AppSettings::saveSettings() const
{
	QSettings settings;
	settings.setPath( "NGSoft", "SMSManager" );
	
	settings.writeEntry( "/general/start_min", start_min );
	settings.writeEntry( "/general/auto_start_deamon", auto_start_deamon );
	settings.writeEntry( "/general/contact_pattern", contact_pattern );
	settings.writeEntry( "/general/contact_local_name", contact_local.Name );
	settings.writeEntry( "/general/contact_local_address", contact_local.Address );
	settings.writeEntry( "/general/show_deamon_error", show_deamon_error );
	settings.writeEntry( "/general/prefix_num", prefix_num );
	
	settings.writeEntry( "/popup/show_popup", show_popup );
	settings.writeEntry( "/popup/popup_img", popup_pixmap_path);
	settings.writeEntry( "/popup/popup_snd", popup_sound );
	
	settings.writeEntry( "/devices/dev1", dev_config.primaryDevice );
	settings.writeEntry( "/devices/dev2", dev_config.secondaryDevice );
	settings.writeEntry( "/devices/bauds", dev_config.baudrate );
	settings.writeEntry( "/devices/init", dev_config.initString );
	settings.writeEntry( "/devices/sca", dev_config.serviceCentreAddress );
	settings.writeEntry( "/devices/xonxoff", dev_config.xonxoff );
				    
	settings.writeEntry( "/devices/phonebook", rm_phonebook );
}

QString AppSettings::configPath() const
{
	return cfg_path;
}

QString AppSettings::boxFilePath(const QString& name) const
{
	return QString(cfg_path + "/" + name + ".box");
}

QString AppSettings::phoneBookFilePath() const
{
	return QString(cfg_path + "/contacts.pb");
}


void AppSettings::createBoxFile(const QString& name) const
{
	QFile box_file( boxFilePath(name) );
	if( !box_file.exists() )
	{
		box_file.open(IO_WriteOnly);
		box_file.close();
	}
}

void AppSettings::createPhoneBookFile() const
{
	QFile box_file( phoneBookFilePath() );
	if( !box_file.exists() )
	{
		box_file.open(IO_WriteOnly);
		box_file.close();
	}
}

SMSManager::SMSDeviceConfig AppSettings::deviceConfig() const
{
	return dev_config;
}

SMSManager::SMSContact AppSettings::localContact() const
{
	return contact_local;
}

QString AppSettings::remotePhoneBook() const
{
	return rm_phonebook;
}

bool AppSettings::startMin() const
{
	return start_min;
}

bool AppSettings::autoStartDeamon() const
{
	return auto_start_deamon;
}

const QString& AppSettings::contactPattern() const
{
	return contact_pattern;
}

bool AppSettings::showPopup() const
{
	return show_popup;
}

const QPixmap& AppSettings::popupPixmap() const
{
	return popup_pixmap;
}

QString AppSettings::popupSound() const
{
	return popup_sound;
}

bool AppSettings::prefixIncomingNumber() const
{
	return prefix_num;
}

bool AppSettings::showDeamonError() const
{
	return show_deamon_error;
}

