#!/bin/sh

# Released under the GPL
# Sets keyboard light (if keyboard light hardware is installed) to
# given val$ or uses default / custom brightness.
# Parameter $1 controls behavior:
# - no parameter: Status is displayed and returned
# - "on": Switch keyboard light on, using either maximum brightness 255 or, if present, brightenss value from file /etc/pandora/conf/keyboard_light_brightness
# - "off" or 0 Switch keyboard light off.
# - value 1..255: Switch keyboard light on, using given brightness value
# Valid values: 0 (off) to 255 (full brightness)

if [ -z $1 ]; then
	# Report and return status:
        kbl_status=`cat /sys/class/leds/pandora\:\:keypad_bl/brightness`
        if [ $kbl_status -eq 0 ]; then
                echo Keyboard Light Off
        else
                echo Keyboard Light On. Brightness \(0 .. 255\): $kbl_status
        fi
        return $kbl_status
elif [ $1 == "off" ]; then
	echo Switching off keyboard light
        echo 0 > /sys/class/leds/pandora\:\:keypad_bl/brightness
elif [ $1 -eq 0 ]; then
	echo Switching off keyboard light
        echo 0 > /sys/class/leds/pandora\:\:keypad_bl/brightness
elif [ $1 -gt 0 ] && [ $1 -lt 256 ]; then
	echo Switching on keyboard light using brightness $1
        echo $1 > /sys/class/leds/pandora\:\:keypad_bl/brightness
elif [ $1 == "on" ]; then
	echo Switching on keyboard light
	if [ -f /etc/pandora/conf/keyboard_light_brightness ]; then
		bright=`cat /etc/pandora/conf/keyboard_light_brightness`
		echo ...using custom brightness $bright
	else
		bright=255
		echo ...using default brightness $bright
	fi
        echo $bright > /sys/class/leds/pandora\:\:keypad_bl/brightness
else
	echo Invalid parameter
fi
