#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Remove an eventual trailing '\n' character */
#define DROPNL(a) {\
                    if (a[strlen(a)-1] == '\n') \
                      a[strlen(a)-1] = 0; \
                  }
                  
#define MALLOCINCR 128

/* Read a full line from standard input, and return a pointer to a 
   static buffer. */
char *getline(void)
{
  static char *buf = NULL;
  static size_t buflen = 0;
  
  /* If the buffer hasn't been allocated, let's do it */
  if (!buflen)
  {
    buf=malloc(MALLOCINCR);
  
    /* If the allocation failed, return a NULL, and display an error 
       message */
    if (!buf)
    {
      fprintf(stderr, "Unable to allocate %d bytes of memory.\n", 
              MALLOCINCR);
      return NULL;
    }
    else
      buflen = MALLOCINCR;
  }
  
  /* We'll read the next line, enlarging the buffer if necessary. */
  buf[0] = 0;
  fgets(buf, buflen, stdin);
  while ((!feof(stdin)) && (buf[strlen(buf)-1] != '\n'))
  {
    char *tmp;
    
    /* The buffer is too small, let's reallocate it. */
    tmp=realloc(buf, buflen+MALLOCINCR);
    if (!tmp)
    {
      fprintf(stderr, "Not enough memory to reallocate the input buffer to %d bytes.\n", 
              buflen+MALLOCINCR);
      return NULL;
    }
    else
      buflen+=MALLOCINCR;
    fgets(buf+buflen-MALLOCINCR, MALLOCINCR, stdin);
  }
  
  return buf;
}


int main(void)
{
  char *hold = NULL,
       *current = NULL;
       
  /* While we have read something... */
  while (((current = getline()) != NULL) && current[0])
  {
    if (current[0] != '\n')
    {
      /* The current line is not empty, we can eventually perform 
         changes on the saved line. */ 
      if (hold)
      {
        /* The saved line exists, so we can examine it. */
        if (strlen(hold) > 1)
        {
          /* The saved line has more than 1 character, we can verify if 
             it ends with ".\". */ 
          if (  (hold[strlen(hold)-1] == '\\') 
              && (hold[strlen(hold)-2] == '*') )
          {
            /* If that's true, then don't add a trailing space. */
            /* and remove the *-\ and replace it by \par */
            hold[strlen(hold)-2]='\0';
            printf("%s\\par\n", hold);
          }
          else
          {
            /* False, let's add a trailing space. */
            printf("%s \n", hold);
          }
        }
        else
        {
          /* The saved line has at most 1 character, we verify that it 
             has at least 1 character to add the trailing space. */ 
          if (strlen(hold) > 0)
            printf("%s \n", hold);
          else
            printf("%s\n", hold);
        }
      }
    }
    else
    {
      /* The current line is empty, we must then output the saved line 
         if it exists. */
      if (hold)
        printf("%s\n", hold);
    }
      
    /* Let's save the current line. */
    free(hold);
    DROPNL(current);
    hold=strdup(current);
    if (!hold)
    {
      fprintf(stderr, "Not enough memory to hold a copy of the current line.\n");
      return EXIT_FAILURE;
    }
  }
  
  /* We're now out of the main loop, we still have to flush anything 
     pending. */
  if (hold)
  {
    printf("%s\n", hold);
    free(hold);
  }
  
  return EXIT_SUCCESS;
}
