# The View class is interface between the VideoMode and the presentation
# layer. It does not provide any links for the menu, but provides a link to the
# current video publication which is used to compose the path.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::VideoMode::View;

our @ISA = qw(CMSsh::Mode::View);

use strict;
use CMSsh::Mode::View;
use CMSsh::VideoMode::Config;

my $Cfg = CMSsh::VideoMode::Config->new;

sub get_tmpl_params (;$) {
    return [qw(HTDOCS_VIDEO URLKEY_VIDEO)];
}

sub get_path ($$) {
    my ($self, $publication) = @_;
    return [{ href => $Cfg->get('URLKEY_VIDEO') . '/' . $publication->get_uri,
              title => $publication->get_name }];
}

1
