# Utils implements common subroutines used by the Presentation/Administration
# scripts and another classes.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Utils;

use strict;
use CMSsh::Messages;
use CMSsh::Config;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
    collect_modes_data 
);

my $Msg = CMSsh::Messages->new;
my $Cfg = CMSsh::Config->new;

sub collect_modes_data ($$) {
    my ($extractor, $predicate) = @_;

    my (@result, $mode_name);
    foreach $mode_name (@{$Cfg->get('ENABLED_MODES')}) {
        unless (eval "use CMSsh::${mode_name}Mode; 1") {
            warn $Msg->get('USE_FAILURE', $mode_name, $@);
            next;
        }
        my $mode = "CMSsh::${mode_name}Mode"->new;
        next if ($predicate && !&$predicate($mode));
        push @result, &$extractor($mode);
    }

    return @result;
}

1
