# Object is a parent class for all file system objects like file and directory.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::FileSystem::Object;

use strict;
use CMSsh::Config;
use CMSsh::Messages;

my $Cfg = CMSsh::Config->new;
my $Msg = CMSsh::Messages->new;

sub new ($$) {
    my ($class_name, $path) = @_;
    
    my $self = {
        _path => $path,
        _name => undef,
    };
    bless $self, $class_name;

    $self->_update_name;

    return $self;
}

sub _update_name ($) {
    my $self = shift;
    $self->{_name} = ($self->{_path} =~ /\/([^\/]+)$/) ? $1 : undef;
}

sub get_name ($) {
    my $self = shift;
    return $self->{_name};
}

sub get_path ($) {
    my $self = shift;
    return $self->{_path};
}

sub get_htdocs_path ($) {
    my $self = shift;
    
    my $root_htdocs = $Cfg->get('ROOT_HTDOCS');
    $self->{_path} =~ /^$root_htdocs(.*)$/;

    return $1;
}

sub get_parent_path ($) {
    my $self = shift;
    return ($self->{_path} =~ /^(.*)\/([^\/]+)$/) ? $1 : undef;
}

1
