# The Messages class defines messages specific to the the DocumentMode.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::DocumentMode::Messages;

our @ISA = qw(CMSsh::Messages);

use strict;
use utf8;

my $Messages = {
    CANT_GET_PUB_MTDATA =>  "Can not get metadata of the '%s' publication.",
    CANT_GET_PUB_MARKUP =>  "Can not get markup of the '%s' publication.",
    CANT_GET_MKD_MTDATA =>  "Can not get metadata of the '%s' markdown file.",
    CANT_GET_MKD_MARKUP =>  "Can not get markup of the '%s' markdown file.",
};

sub new ($) {
    my $class_name = shift;

    my $self = CMSsh::Messages->new;
    $self->_install_gloss($Messages);

    bless ($self, $class_name);
    return $self;
}

1
