#!/usr/bin/perl -w

# gallery.pl is an image viewer. If the specified parameter is an album, it
# displays a list of subalbums and thumbnails of images localed in the current
# album. If the specified parameter is an image, a preview is displayed.
# 
# Accepts one optional parameter:
#   path - encoded URI to an album/image.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

BEGIN {
    push (@INC, "../lib");
}

use 5.8.8;
use strict;
use CGI;
use CMSsh::Presentation::TemplateHandler;
use CMSsh::Presentation::Utils qw(cgi_die);
use CMSsh::GalleryMode;

my $mode = CMSsh::GalleryMode->new;
my $msg = $mode->get_messages;
my $cfg = $mode->get_config;

my $cgi = CGI->new;
my $uri = '/' . ($cgi->param('path') || '');

my $vars; # Template variables

my $publication = $mode->find_publication($uri)
    or cgi_die $msg->get('CANT_FIND_PUB');
if ($publication->get_type eq 'GalleryMode::Image') {
# Show a single image
    my $img = $publication;
    my $view = $img->get_view;

# Set prev/next images
    my $curr_album = $img->get_album;
    my $listing = $curr_album->get_listing;
    cgi_die $msg->get('CANT_LIST_COLL', $curr_album->get_uri) unless ($listing);

    my $images_ref = $listing->{CMSsh::GalleryMode::Image->get_type};
    my $img_count = scalar (@{$images_ref});
    my $i;
    for ($i = 0; $i < $img_count; $i++) {
        last if ($images_ref->[$i]->get_uri eq $img->get_uri);
    }
    cgi_die $msg->get('CANT_FIND_PUB') if ($i == $img_count);

    my $prev_img = $images_ref->[$i-1] if ($i > 0);
    my $next_img = $images_ref->[$i+1] if ($i < $img_count - 1);

    $vars = {
        single => 1,
        image => $view,
        title => $cfg->get('TITLE_GALLERY') . ' - ' . $img->get_uri,
        next_img => $next_img ? $next_img->get_preview : undef,
        prev_img => $prev_img ? $prev_img->get_preview : undef,
    };
} elsif ($publication->get_type eq 'GalleryMode::Album') {
# List an album
    my $alb = $publication;
    my $previews = $alb->get_inner_preview;

    $vars = {
        single => 0,
        albums => $previews->{CMSsh::GalleryMode::Album->get_type},
        images => $previews->{CMSsh::GalleryMode::Image->get_type},
        title => $cfg->get('TITLE_GALLERY') .
                     (!$alb->is_root && ' - ' . $alb->get_uri),
    };
} else {
    die $msg->get('UNKNOWN_PUB_TYPE',
                  $publication->get_uri, $publication->get_type);
}
my $th = CMSsh::Presentation::TemplateHandler->new($mode->get_view);
$th->process('gallery', $vars, $publication);

