/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import virtuoso.jdbc3.Closeable;
import virtuoso.jdbc3.ConnectionWrapper;
import virtuoso.jdbc3.StatementWrapper;
import virtuoso.jdbc3.VirtuosoException;

public class ResultSetWrapper
implements ResultSet,
Closeable {
    private ConnectionWrapper wconn;
    private StatementWrapper wstmt;
    private ResultSet rs;

    protected ResultSetWrapper(ConnectionWrapper connectionWrapper, StatementWrapper statementWrapper, ResultSet resultSet) {
        this.wconn = connectionWrapper;
        this.wstmt = statementWrapper;
        this.rs = resultSet;
        this.wstmt.addObjToClose(this);
    }

    protected ResultSetWrapper(ConnectionWrapper connectionWrapper, ResultSet resultSet) {
        this.wconn = connectionWrapper;
        this.wstmt = null;
        this.rs = resultSet;
        this.wconn.addObjToClose(this);
    }

    private void exceptionOccurred(SQLException sQLException) {
        if (this.wconn != null) {
            this.wconn.exceptionOccurred(sQLException);
        }
    }

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    public void close() throws SQLException {
        if (this.rs == null) {
            return;
        }
        this.check_close();
        try {
            this.rs.close();
            if (this.wstmt == null) {
                this.wconn.removeObjFromClose(this);
            } else {
                this.wstmt.removeObjFromClose(this);
                this.wstmt.close();
            }
            this.rs = null;
            this.wstmt = null;
            this.wconn = null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean next() throws SQLException {
        this.check_close();
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean wasNull() throws SQLException {
        this.check_close();
        try {
            return this.rs.wasNull();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getString(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getString(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBoolean(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public byte getByte(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getByte(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public short getShort(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getShort(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getInt(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getInt(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public long getLong(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getLong(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public float getFloat(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getFloat(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public double getDouble(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDouble(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBytes(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Date getDate(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Time getTime(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getString(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getString(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBoolean(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public byte getByte(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getByte(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public short getShort(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getShort(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getInt(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getInt(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public long getLong(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getLong(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public float getFloat(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getFloat(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public double getDouble(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDouble(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(string, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBytes(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Date getDate(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Time getTime(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.check_close();
        try {
            return this.rs.getWarnings();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        this.check_close();
        try {
            this.rs.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getCursorName() throws SQLException {
        this.check_close();
        try {
            return this.rs.getCursorName();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        try {
            return this.rs.getMetaData();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Object getObject(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Object getObject(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int findColumn(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        this.check_close();
        try {
            return this.rs.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isAfterLast() throws SQLException {
        this.check_close();
        try {
            return this.rs.isAfterLast();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isFirst() throws SQLException {
        this.check_close();
        try {
            return this.rs.isFirst();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isLast() throws SQLException {
        this.check_close();
        try {
            return this.rs.isLast();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void beforeFirst() throws SQLException {
        this.check_close();
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void afterLast() throws SQLException {
        this.check_close();
        try {
            this.rs.afterLast();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean first() throws SQLException {
        this.check_close();
        try {
            return this.rs.first();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean last() throws SQLException {
        this.check_close();
        try {
            return this.rs.last();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getRow() throws SQLException {
        this.check_close();
        try {
            return this.rs.getRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean absolute(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.absolute(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean relative(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.relative(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean previous() throws SQLException {
        this.check_close();
        try {
            return this.rs.previous();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        this.check_close();
        try {
            this.rs.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getFetchDirection() throws SQLException {
        this.check_close();
        try {
            return this.rs.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        this.check_close();
        try {
            this.rs.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getFetchSize() throws SQLException {
        this.check_close();
        try {
            return this.rs.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getType() throws SQLException {
        this.check_close();
        try {
            return this.rs.getType();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getConcurrency() throws SQLException {
        this.check_close();
        try {
            return this.rs.getConcurrency();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean rowUpdated() throws SQLException {
        this.check_close();
        try {
            return this.rs.rowUpdated();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean rowInserted() throws SQLException {
        this.check_close();
        try {
            return this.rs.rowInserted();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean rowDeleted() throws SQLException {
        this.check_close();
        try {
            return this.rs.rowDeleted();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateNull(int n) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNull(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.check_close();
        try {
            this.rs.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        this.check_close();
        try {
            this.rs.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.check_close();
        try {
            this.rs.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        this.check_close();
        try {
            this.rs.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.check_close();
        try {
            this.rs.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateString(int n, String string) throws SQLException {
        this.check_close();
        try {
            this.rs.updateString(n, string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateNull(String string) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNull(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.check_close();
        try {
            this.rs.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        this.check_close();
        try {
            this.rs.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        this.check_close();
        try {
            this.rs.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        this.check_close();
        try {
            this.rs.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.check_close();
        try {
            this.rs.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.check_close();
        try {
            this.rs.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(string, object, n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void insertRow() throws SQLException {
        this.check_close();
        try {
            this.rs.insertRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateRow() throws SQLException {
        this.check_close();
        try {
            this.rs.updateRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void deleteRow() throws SQLException {
        this.check_close();
        try {
            this.rs.deleteRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void refreshRow() throws SQLException {
        this.check_close();
        try {
            this.rs.refreshRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.check_close();
        try {
            this.rs.cancelRowUpdates();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.check_close();
        try {
            this.rs.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.check_close();
        try {
            this.rs.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Statement getStatement() throws SQLException {
        this.check_close();
        return this.wstmt;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(n, map);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Ref getRef(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getRef(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Blob getBlob(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBlob(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Clob getClob(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getClob(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Array getArray(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getArray(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(string, map);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Ref getRef(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getRef(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBlob(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Clob getClob(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getClob(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Array getArray(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getArray(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public URL getURL(int n) throws SQLException {
        this.check_close();
        try {
            return this.rs.getURL(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public URL getURL(String string) throws SQLException {
        this.check_close();
        try {
            return this.rs.getURL(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.check_close();
        try {
            this.rs.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.check_close();
        try {
            this.rs.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.check_close();
        try {
            this.rs.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.check_close();
        try {
            this.rs.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    private void check_close() throws SQLException {
        if (this.rs == null) {
            throw new VirtuosoException("The ResultSet is closed.", 0);
        }
    }
}

