/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import virtuoso.javax.BaseRowSet;
import virtuoso.javax.OPLMessage_x;

public class OPLJdbcRowSet
extends BaseRowSet {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private boolean doDisconnect = false;

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    private Connection connect() throws SQLException {
        String string = this.getDataSourceName();
        if (string != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(string);
                return dataSource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException namingException) {
                throw OPLMessage_x.makeException(namingException);
            }
        }
        string = this.getUrl();
        if (string != null) {
            return DriverManager.getConnection(string, this.getUsername(), this.getPassword());
        }
        return null;
    }

    private void setParams(PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return;
        }
        block14: for (int i = 0; i < objectArray.length; ++i) {
            BaseRowSet.Parameter parameter = (BaseRowSet.Parameter)objectArray[i];
            switch (parameter.jType) {
                case 0: {
                    preparedStatement.setObject(i + 1, parameter.value);
                    continue block14;
                }
                case 1: {
                    preparedStatement.setObject(i + 1, parameter.value, parameter.sqlType);
                    continue block14;
                }
                case 2: {
                    preparedStatement.setObject(i + 1, parameter.value, parameter.sqlType, parameter.scale);
                    continue block14;
                }
                case 3: {
                    preparedStatement.setAsciiStream(i + 1, (InputStream)parameter.value, parameter.length);
                    continue block14;
                }
                case 4: {
                    preparedStatement.setBinaryStream(i + 1, (InputStream)parameter.value, parameter.length);
                    continue block14;
                }
                case 5: {
                    preparedStatement.setUnicodeStream(i + 1, (InputStream)parameter.value, parameter.length);
                    continue block14;
                }
                case 6: {
                    preparedStatement.setCharacterStream(i + 1, (Reader)parameter.value, parameter.length);
                    continue block14;
                }
                case 7: {
                    preparedStatement.setDate(i + 1, (Date)parameter.value, parameter.cal);
                    continue block14;
                }
                case 8: {
                    preparedStatement.setTime(i + 1, (Time)parameter.value, parameter.cal);
                    continue block14;
                }
                case 9: {
                    preparedStatement.setTimestamp(i + 1, (Timestamp)parameter.value, parameter.cal);
                    continue block14;
                }
                case 10: {
                    preparedStatement.setNull(i + 1, parameter.sqlType);
                    continue block14;
                }
                case 11: {
                    preparedStatement.setNull(i + 1, parameter.sqlType, parameter.typeName);
                    continue block14;
                }
                default: {
                    throw OPLMessage_x.makeException(10);
                }
            }
        }
    }

    public synchronized void execute() throws SQLException {
        if (this.conn == null) {
            this.conn = this.connect();
            this.doDisconnect = true;
        }
        if (this.conn == null || this.getCommand() == null) {
            throw OPLMessage_x.makeException(11);
        }
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        this.setParams(preparedStatement, this.getParams());
        try {
            preparedStatement.setMaxRows(this.getMaxRows());
            preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = preparedStatement.executeQuery();
        this.notifyListener(3);
    }

    public void execute(Connection connection) throws SQLException {
        this.conn = connection;
        this.execute();
    }

    public synchronized void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && this.doDisconnect) {
            this.conn.close();
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.check_close();
        this.rs.cancelRowUpdates();
        this.notifyListener(2);
    }

    public synchronized boolean next() throws SQLException {
        this.check_close();
        boolean bl = this.rs.next();
        this.notifyListener(1);
        return bl;
    }

    public synchronized boolean previous() throws SQLException {
        this.check_close();
        boolean bl = this.rs.previous();
        this.notifyListener(1);
        return bl;
    }

    public synchronized boolean first() throws SQLException {
        this.check_close();
        boolean bl = this.rs.first();
        this.notifyListener(1);
        return bl;
    }

    public synchronized boolean last() throws SQLException {
        this.check_close();
        boolean bl = this.rs.last();
        this.notifyListener(1);
        return bl;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        this.check_close();
        boolean bl = this.rs.absolute(n);
        this.notifyListener(1);
        return bl;
    }

    public synchronized boolean relative(int n) throws SQLException {
        this.check_close();
        boolean bl = this.rs.relative(n);
        this.notifyListener(1);
        return bl;
    }

    public synchronized void beforeFirst() throws SQLException {
        this.check_close();
        this.rs.beforeFirst();
        this.notifyListener(1);
    }

    public synchronized void afterLast() throws SQLException {
        this.check_close();
        this.rs.afterLast();
        this.notifyListener(1);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.check_close();
        return this.rs.isBeforeFirst();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        this.check_close();
        return this.rs.isAfterLast();
    }

    public synchronized boolean isFirst() throws SQLException {
        this.check_close();
        return this.rs.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        this.check_close();
        return this.rs.isLast();
    }

    public synchronized int getRow() throws SQLException {
        this.check_close();
        return this.rs.getRow();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        this.check_close();
        return this.rs.rowUpdated();
    }

    public synchronized boolean rowInserted() throws SQLException {
        this.check_close();
        return this.rs.rowInserted();
    }

    public synchronized boolean rowDeleted() throws SQLException {
        this.check_close();
        return this.rs.rowDeleted();
    }

    public synchronized void refreshRow() throws SQLException {
        this.check_close();
        this.rs.refreshRow();
    }

    public synchronized void insertRow() throws SQLException {
        this.check_close();
        this.rs.insertRow();
        this.notifyListener(2);
    }

    public synchronized void updateRow() throws SQLException {
        this.check_close();
        this.rs.updateRow();
        this.notifyListener(2);
    }

    public synchronized void deleteRow() throws SQLException {
        this.check_close();
        this.rs.deleteRow();
        this.notifyListener(2);
    }

    public synchronized void moveToInsertRow() throws SQLException {
        this.check_close();
        this.rs.moveToInsertRow();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.check_close();
        this.rs.moveToCurrentRow();
    }

    public synchronized boolean wasNull() throws SQLException {
        this.check_close();
        return this.rs.wasNull();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.check_close();
        return this.rs.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.check_close();
        this.rs.clearWarnings();
    }

    public synchronized String getCursorName() throws SQLException {
        this.check_close();
        return this.rs.getCursorName();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        return this.rs.getMetaData();
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.check_close();
        return this.rs.findColumn(string);
    }

    public synchronized String getString(int n) throws SQLException {
        this.check_close();
        return this.rs.getString(n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(n);
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.check_close();
        return this.rs.getByte(n);
    }

    public synchronized short getShort(int n) throws SQLException {
        this.check_close();
        return this.rs.getShort(n);
    }

    public synchronized int getInt(int n) throws SQLException {
        this.check_close();
        return this.rs.getInt(n);
    }

    public synchronized long getLong(int n) throws SQLException {
        this.check_close();
        return this.rs.getLong(n);
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.check_close();
        return this.rs.getFloat(n);
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.check_close();
        return this.rs.getDouble(n);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(n, n2);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.check_close();
        return this.rs.getBytes(n);
    }

    public synchronized Date getDate(int n) throws SQLException {
        this.check_close();
        return this.rs.getDate(n);
    }

    public synchronized Time getTime(int n) throws SQLException {
        this.check_close();
        return this.rs.getTime(n);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(n);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(n);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(n);
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.check_close();
        return this.rs.getObject(n);
    }

    public synchronized String getString(String string) throws SQLException {
        this.check_close();
        return this.rs.getString(string);
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(string);
    }

    public synchronized byte getByte(String string) throws SQLException {
        this.check_close();
        return this.rs.getByte(string);
    }

    public synchronized short getShort(String string) throws SQLException {
        this.check_close();
        return this.rs.getShort(string);
    }

    public synchronized int getInt(String string) throws SQLException {
        this.check_close();
        return this.rs.getInt(string);
    }

    public synchronized long getLong(String string) throws SQLException {
        this.check_close();
        return this.rs.getLong(string);
    }

    public synchronized float getFloat(String string) throws SQLException {
        this.check_close();
        return this.rs.getFloat(string);
    }

    public synchronized double getDouble(String string) throws SQLException {
        this.check_close();
        return this.rs.getDouble(string);
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(string, n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        this.check_close();
        return this.rs.getBytes(string);
    }

    public synchronized Date getDate(String string) throws SQLException {
        this.check_close();
        return this.rs.getDate(string);
    }

    public synchronized Time getTime(String string) throws SQLException {
        this.check_close();
        return this.rs.getTime(string);
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(string);
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(string);
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(string);
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(string);
    }

    public synchronized Object getObject(String string) throws SQLException {
        this.check_close();
        return this.rs.getObject(string);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(n);
    }

    public synchronized Reader getCharacterStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(string);
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(string);
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.check_close();
        this.rs.updateNull(n);
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(n, bl);
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.check_close();
        this.rs.updateByte(n, by);
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        this.check_close();
        this.rs.updateShort(n, s);
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.check_close();
        this.rs.updateInt(n, n2);
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        this.check_close();
        this.rs.updateLong(n, l);
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.check_close();
        this.rs.updateFloat(n, f);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.check_close();
        this.rs.updateDouble(n, d);
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        this.check_close();
        this.rs.updateString(n, string);
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.check_close();
        this.rs.updateBytes(n, byArray);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.check_close();
        this.rs.updateDate(n, date);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.check_close();
        this.rs.updateTime(n, time);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(n, timestamp);
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(n, reader, n2);
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        this.check_close();
        this.rs.updateObject(n, object, n2);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.check_close();
        this.rs.updateObject(n, object);
    }

    public synchronized void updateNull(String string) throws SQLException {
        this.check_close();
        this.rs.updateNull(string);
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(string, bl);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.check_close();
        this.rs.updateByte(string, by);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        this.check_close();
        this.rs.updateShort(string, s);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        this.check_close();
        this.rs.updateInt(string, n);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        this.check_close();
        this.rs.updateLong(string, l);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.check_close();
        this.rs.updateFloat(string, f);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.check_close();
        this.rs.updateDouble(string, d);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        this.check_close();
        this.rs.updateString(string, string2);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.check_close();
        this.rs.updateBytes(string, byArray);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.check_close();
        this.rs.updateDate(string, date);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.check_close();
        this.rs.updateTime(string, time);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(string, timestamp);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(string, reader, n);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.check_close();
        this.rs.updateObject(string, object, n);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.check_close();
        this.rs.updateObject(string, object);
    }

    public synchronized Statement getStatement() throws SQLException {
        this.check_close();
        return this.rs.getStatement();
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        this.check_close();
        return this.rs.getObject(n, map);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        this.check_close();
        return this.rs.getRef(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        this.check_close();
        return this.rs.getBlob(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        this.check_close();
        return this.rs.getClob(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        this.check_close();
        return this.rs.getArray(n);
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        this.check_close();
        return this.rs.getObject(string, map);
    }

    public synchronized Ref getRef(String string) throws SQLException {
        this.check_close();
        return this.rs.getRef(string);
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        this.check_close();
        return this.rs.getBlob(string);
    }

    public synchronized Clob getClob(String string) throws SQLException {
        this.check_close();
        return this.rs.getClob(string);
    }

    public synchronized Array getArray(String string) throws SQLException {
        this.check_close();
        return this.rs.getArray(string);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getDate(n, calendar);
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getDate(string, calendar);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTime(n, calendar);
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTime(string, calendar);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(n, calendar);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(string, calendar);
    }

    public synchronized URL getURL(int n) throws SQLException {
        this.check_close();
        return this.rs.getURL(n);
    }

    public synchronized URL getURL(String string) throws SQLException {
        this.check_close();
        return this.rs.getURL(string);
    }

    public synchronized void updateRef(int n, Ref ref) throws SQLException {
        this.check_close();
        this.rs.updateRef(n, ref);
    }

    public synchronized void updateRef(String string, Ref ref) throws SQLException {
        this.check_close();
        this.rs.updateRef(string, ref);
    }

    public synchronized void updateBlob(int n, Blob blob) throws SQLException {
        this.check_close();
        this.rs.updateBlob(n, blob);
    }

    public synchronized void updateBlob(String string, Blob blob) throws SQLException {
        this.check_close();
        this.rs.updateBlob(string, blob);
    }

    public synchronized void updateClob(int n, Clob clob) throws SQLException {
        this.check_close();
        this.rs.updateClob(n, clob);
    }

    public synchronized void updateClob(String string, Clob clob) throws SQLException {
        this.check_close();
        this.rs.updateClob(string, clob);
    }

    public synchronized void updateArray(int n, Array array) throws SQLException {
        this.check_close();
        this.rs.updateArray(n, array);
    }

    public synchronized void updateArray(String string, Array array) throws SQLException {
        this.check_close();
        this.rs.updateArray(string, array);
    }

    private void check_close() throws SQLException {
        if (this.rs == null) {
            throw OPLMessage_x.makeException(7);
        }
    }
}

