/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureClassLoader
extends ClassLoader {
    private final HashMap<CodeSource, ProtectionDomain> protectionDomainCache = new HashMap();

    protected SecureClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected SecureClassLoader() {
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
        return super.defineClass(name, b, off, len, this.getProtectionDomain(cs));
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, CodeSource cs) {
        return super.defineClass(name, b, this.getProtectionDomain(cs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource cs) {
        ProtectionDomain protectionDomain = null;
        if (cs != null) {
            HashMap<CodeSource, ProtectionDomain> hashMap = this.protectionDomainCache;
            synchronized (hashMap) {
                protectionDomain = this.protectionDomainCache.get(cs);
            }
            if (protectionDomain == null) {
                protectionDomain = new ProtectionDomain(cs, this.getPermissions(cs), this, null);
                hashMap = this.protectionDomainCache;
                synchronized (hashMap) {
                    ProtectionDomain domain = this.protectionDomainCache.get(cs);
                    if (domain == null) {
                        this.protectionDomainCache.put(cs, protectionDomain);
                    } else {
                        protectionDomain = domain;
                    }
                }
            }
        }
        return protectionDomain;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        Policy policy = Policy.getCurrentPolicy();
        return policy.getPermissions(cs);
    }
}

