/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class JarURLConnection
extends URLConnection {
    private final URL jarFileURL;
    protected URLConnection jarFileURLConnection;
    private final String entryName;

    protected JarURLConnection(URL url) throws MalformedURLException {
        super(url);
        if (!url.getProtocol().equals("jar")) {
            throw new MalformedURLException(url + ": Not jar protocol.");
        }
        String spec = url.getFile();
        int bang = spec.indexOf("!/");
        if (bang == -1) {
            throw new MalformedURLException(url + ": No `!/' in spec.");
        }
        this.jarFileURL = new URL(spec.substring(0, bang));
        this.entryName = spec.length() == bang + 2 ? null : spec.substring(bang + 2);
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarEntry getJarEntry() throws IOException {
        if (this.entryName == null) {
            return null;
        }
        JarFile jarFile = this.getJarFile();
        return jarFile != null ? jarFile.getJarEntry(this.entryName) : null;
    }

    public abstract JarFile getJarFile() throws IOException;

    public Certificate[] getCertificates() throws IOException {
        JarEntry entry = this.getJarEntry();
        return entry != null ? entry.getCertificates() : null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    public Attributes getAttributes() throws IOException {
        JarEntry entry = this.getJarEntry();
        return entry != null ? entry.getAttributes() : null;
    }

    public Manifest getManifest() throws IOException {
        JarFile file = this.getJarFile();
        return file != null ? file.getManifest() : null;
    }
}

