/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.giop;

import gnu.CORBA.IOR;
import gnu.CORBA.NamingService.NameTransformer;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.java.lang.CPStringBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class CorbalocParser
extends NameTransformer {
    public static final String pxCORBALOC = "corbaloc";
    public static final String pxCORBANAME = "corbaname";
    public static final String pxIOR = "ior";
    public static final String pxFILE = "file://";
    public static final String pxFTP = "ftp://";
    public static final String pxHTTP = "http://";
    public static final String IIOP = "iiop";
    public static final String RIR = "rir";
    public static final int DEFAULT_PORT = 2809;
    public static final String DEFAULT_NAME = "NameService";
    static NameTransformer converter;
    int p;
    String[] t;

    public synchronized String[] corbaloc(String corbaloc, ORB orb) throws InvalidNameException {
        return this.corbaloc(corbaloc, orb, 0);
    }

    private String[] corbaloc(String corbaloc, ORB orb, int recursion) throws InvalidNameException {
        if (recursion > 10) {
            throw new DATA_CONVERSION("More than 10 redirections");
        }
        if (corbaloc.startsWith(pxFILE)) {
            return this.corbaloc(this.readFile(corbaloc.substring(pxFILE.length())), orb, recursion + 1);
        }
        if (corbaloc.startsWith(pxHTTP)) {
            return this.corbaloc(this.readUrl(corbaloc), orb, recursion + 1);
        }
        if (corbaloc.startsWith(pxFTP)) {
            return this.corbaloc(this.readUrl(corbaloc), orb, recursion + 1);
        }
        int major = 1;
        int minor = 0;
        int port = 2809;
        StringTokenizer st = new StringTokenizer(corbaloc, ":@/.,#", true);
        this.t = new String[st.countTokens()];
        int i = 0;
        while (i < this.t.length) {
            this.t[i] = st.nextToken();
            ++i;
        }
        this.p = 0;
        if (!this.t[this.p].startsWith(pxCORBANAME)) {
            throw new InvalidNameException(String.valueOf(corbaloc) + " must start with " + pxCORBANAME);
        }
        ++this.p;
        if (!this.t[this.p++].equals(":")) {
            throw new BAD_PARAM("Syntax (':' expected after name prefix)");
        }
        if (this.t[this.p].equals(RIR)) {
            ++this.p;
            if (!this.t[this.p++].equals(":")) {
                throw new BAD_PARAM("':' expected after 'rir'");
            }
            String key = this.readKey("/");
            try {
                Object object = orb.resolve_initial_references(key);
                return this.resolve(orb.object_to_string(object));
            }
            catch (InvalidName invalidName) {
                throw new BAD_PARAM("Unknown initial reference '" + key + "'");
            }
        }
        if (this.t[this.p].equals(IIOP) || this.t[this.p].equals(":")) {
            IOR ior = new IOR();
            while (true) {
                String host;
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                } else {
                    ++this.p;
                    if (!this.t[this.p++].equals(":")) {
                        throw new BAD_PARAM("':' expected after 'iiop'");
                    }
                    if (this.t[this.p + 1].equals(".") && this.t[this.p + 3].equals("@")) {
                        try {
                            major = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + "'");
                        }
                        ++this.p;
                        try {
                            minor = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + "'");
                        }
                        ++this.p;
                    }
                }
                ior.Internet.version = new Version(major, minor);
                CPStringBuilder bhost = new CPStringBuilder(corbaloc.length());
                while (!(this.t[this.p].equals(":") || this.t[this.p].equals("/") || this.t[this.p].equals(","))) {
                    bhost.append(this.t[this.p++]);
                }
                ior.Internet.host = host = bhost.toString();
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                    try {
                        port = Integer.parseInt(this.t[this.p++]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BAD_PARAM("Invalid port '" + this.t[this.p - 1] + "'");
                    }
                }
                ior.Internet.port = port;
                ior.Id = "";
                if (!this.t[this.p].equals(",")) break;
                ++this.p;
            }
            String key = this.readKey("/");
            ior.key = key.getBytes();
            return this.resolve(ior.toStringifiedReference());
        }
        throw new InvalidNameException("Unsupported protocol '" + this.t[this.p] + "' (iiop expected)");
    }

    String readFile(String file) {
        File f = new File(file);
        if (!f.exists()) {
            DATA_CONVERSION err = new DATA_CONVERSION(String.valueOf(f.getAbsolutePath()) + " does not exist.");
            err.minor = 1195573270;
        }
        try {
            char[] c = new char[(int)f.length()];
            FileReader fr = new FileReader(f);
            fr.read(c);
            fr.close();
            return new String(c).trim();
        }
        catch (IOException ex) {
            DATA_CONVERSION d = new DATA_CONVERSION();
            d.initCause(ex);
            d.minor = 1195573270;
            throw d;
        }
    }

    String readUrl(String url) {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BAD_PARAM("Malformed URL: '" + url + "'");
        }
        try {
            int c;
            InputStreamReader r = new InputStreamReader(u.openStream());
            CPStringBuilder b = new CPStringBuilder();
            while ((c = r.read()) > 0) {
                b.append((char)c);
            }
            return b.toString().trim();
        }
        catch (Exception exception) {
            DATA_CONVERSION d = new DATA_CONVERSION("Reading " + url + " failed.");
            d.minor = 1195573270;
            throw d;
        }
    }

    private String[] resolve(String nsIor) {
        String[] n = new String[]{nsIor, this.readKey("#")};
        return n;
    }

    private String readKey(String delimiter) throws BAD_PARAM {
        if (this.p < this.t.length && !this.t[this.p].equals(delimiter)) {
            if (this.t[this.p].equals("#")) {
                return DEFAULT_NAME;
            }
            throw new BAD_PARAM("'" + delimiter + "String' expected '" + this.t[this.p] + "' found");
        }
        CPStringBuilder bKey = new CPStringBuilder();
        ++this.p;
        while (this.p < this.t.length && !this.t[this.p].equals("#")) {
            bKey.append(this.t[this.p++]);
        }
        if (bKey.length() == 0) {
            return DEFAULT_NAME;
        }
        try {
            return URLDecoder.decode(bKey.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Unexpected("URLDecoder does not support UTF-8", e);
        }
    }
}

