/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import java.util.HashMap;

public class ObjectId {
    private static HashMap nameIndices = new HashMap();
    private String id;
    private Class klass;

    ObjectId(Class klass) {
        this.klass = klass;
    }

    public boolean isUnused() {
        return this.id == null;
    }

    public String toString() {
        return this.id != null ? this.id : "<unused id>";
    }

    public void init() {
        assert (this.klass != null);
        if (this.id != null) {
            return;
        }
        Integer count = (Integer)nameIndices.get(this.klass);
        if (count == null) {
            count = 0;
        }
        if (this.klass.isArray()) {
            Class<?> ct = this.klass.getComponentType();
            if (ct == Boolean.TYPE) {
                this.id = "booleanArray" + count;
            } else if (ct == Byte.TYPE) {
                this.id = "byteArray" + count;
            } else if (ct == Short.TYPE) {
                this.id = "shortArray" + count;
            } else if (ct == Integer.TYPE) {
                this.id = "intArray" + count;
            } else if (ct == Long.TYPE) {
                this.id = "longArray" + count;
            } else if (ct == Float.TYPE) {
                this.id = "floatArray" + count;
            } else if (ct == Double.TYPE) {
                this.id = "doubleArray" + count;
            }
        } else {
            this.id = String.valueOf(this.klass.getName()) + count;
        }
        nameIndices.put(this.klass, count + 1);
    }
}

