/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.gcj.tools.gc_analyze.BytePtr;
import gnu.gcj.tools.gc_analyze.SymbolTable;
import gnu.gcj.tools.gc_analyze.ToolPrefix;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;

class MemoryMap {
    TreeSet<Range> map = new TreeSet<Range>(new RangeComparator());
    HashMap<String, SymbolTable> symbolTables = new HashMap();
    ByteOrder byteOrder;
    int wordSize;

    static long parseHexLong(String s) {
        if (s.length() > 16) {
            throw new NumberFormatException();
        }
        long r = 0L;
        int i = 0;
        while (i < s.length()) {
            int digit = 0;
            char c = s.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    digit = c - 48;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    digit = 10 + c - 97;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    digit = 10 + c - 65;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            r = (r << 4) + (long)digit;
            ++i;
        }
        return r;
    }

    public MemoryMap(BufferedReader reader, String rawFileName) throws IOException {
        String s;
        FileChannel raw = new RandomAccessFile(rawFileName, "r").getChannel();
        ByteBuffer buf = ByteBuffer.allocate(8);
        raw.read(buf);
        if (buf.hasRemaining()) {
            raw.close();
            throw new EOFException();
        }
        buf.flip();
        this.wordSize = buf.get();
        if (this.wordSize == 8 || this.wordSize == 4) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            buf.rewind();
            this.wordSize = buf.getInt();
            if (this.wordSize == 0) {
                this.wordSize = buf.getInt();
            }
        }
        switch (this.wordSize) {
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IOException("Bad .bytes file header");
            }
        }
        buf = ByteBuffer.allocate(3 * this.wordSize);
        buf.order(this.byteOrder);
        raw.position(0L);
        while (true) {
            long length;
            long dummy;
            buf.clear();
            if (-1 == raw.read(buf)) {
                raw.close();
                break;
            }
            if (buf.hasRemaining()) {
                raw.close();
                throw new EOFException();
            }
            buf.flip();
            long l = dummy = this.wordSize == 4 ? (long)buf.getInt() & 0xFFFFFFFFL : buf.getLong();
            if (dummy != (long)this.wordSize) {
                throw new IOException("Bad .bytes file header");
            }
            long start = this.wordSize == 4 ? (long)buf.getInt() & 0xFFFFFFFFL : buf.getLong();
            long l2 = length = this.wordSize == 4 ? (long)buf.getInt() & 0xFFFFFFFFL : buf.getLong();
            if (length < 0L) {
                throw new IOException("Bad .bytes file header");
            }
            long currentPos = raw.position();
            raw.position(currentPos + length);
            Range range = new Range(start, start + length, rawFileName, currentPos);
            this.map.add(range);
        }
        while ((s = reader.readLine()) != null) {
            if (s.indexOf("Begin address map") < 0) continue;
            while (true) {
                String file;
                int end;
                long offset;
                if ((s = reader.readLine()).indexOf("End address map") >= 0) {
                    this.dump();
                    return;
                }
                int endOfAddress = s.indexOf(45);
                long address = MemoryMap.parseHexLong(s.substring(0, endOfAddress));
                int endOfAddress2 = s.indexOf(32, endOfAddress + 1);
                long address2 = MemoryMap.parseHexLong(s.substring(endOfAddress + 1, endOfAddress2));
                int endOfOffset = s.indexOf(32, endOfAddress2 + 6);
                try {
                    offset = MemoryMap.parseHexLong(s.substring(endOfAddress2 + 6, endOfOffset));
                }
                catch (Exception exception) {
                    offset = 0L;
                }
                if ((end = s.indexOf(47)) <= 0 || (file = s.substring(end)).startsWith("/dev/")) continue;
                Range r = new Range(address, address2, file, offset);
                if (offset == 0L) {
                    try {
                        File f = ToolPrefix.fileForName(file);
                        if (f != null) {
                            SymbolTable st = new SymbolTable(f.getPath());
                            if (st.loadAddr != address) {
                                st.relocation = address - st.loadAddr;
                            }
                            this.symbolTables.put(file, st);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.map.add(r);
            }
        }
    }

    public void dump() {
        System.out.println("MemoryMap:");
        for (Range r : this.map) {
            System.out.println(String.valueOf(Long.toHexString(r.begin)) + "-" + Long.toHexString(r.end) + " -> " + r.filename + " offset " + Long.toHexString(r.offset));
        }
    }

    Range getRange(long addr) {
        Range r = new Range();
        r.begin = addr;
        SortedSet<Range> t = this.map.tailSet(r);
        if (t.isEmpty()) {
            return null;
        }
        Range c = t.first();
        if (c.begin <= addr && addr < c.end) {
            return c;
        }
        return null;
    }

    String getFile(long addr) {
        Range r = this.getRange(addr);
        if (r != null) {
            return r.filename;
        }
        return null;
    }

    long getOffset(long addr) {
        Range r = this.getRange(addr);
        if (r != null) {
            return r.offset;
        }
        return 0L;
    }

    BytePtr getBytePtr(long addr, int length) throws IOException {
        Range r = this.getRange(addr);
        if (r == null) {
            return null;
        }
        File f = ToolPrefix.fileForName(r.filename);
        if (f == null) {
            return null;
        }
        if (addr + (long)length > r.end) {
            length = (int)(r.end - addr);
        }
        ByteBuffer b = ByteBuffer.allocate(length);
        b.order(this.byteOrder);
        FileChannel fc = new RandomAccessFile(f, "r").getChannel();
        fc.position(r.offset + addr - r.begin);
        int nr = fc.read(b);
        fc.close();
        if (nr != length) {
            return null;
        }
        b.flip();
        return new BytePtr(b, this.wordSize);
    }

    public String getSymbol(long addr) {
        Range r = this.getRange(addr);
        if (r == null) {
            return null;
        }
        SymbolTable st = this.symbolTables.get(r.filename);
        if (st == null) {
            return null;
        }
        return st.getSymbol(addr -= st.relocation);
    }

    static class Range {
        long begin;
        long end;
        long offset;
        String filename;

        Range() {
        }

        Range(long b, long e, String s, long o) {
            this.begin = b;
            this.end = e;
            this.filename = s;
            this.offset = o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RangeComparator
    implements Comparator<Range> {
        RangeComparator() {
        }

        @Override
        public int compare(Range r1, Range r2) {
            if (r2.end == 0L && r1.end != 0L) {
                return -this.compare(r2, r1);
            }
            if (r1.begin < r2.begin) {
                return -1;
            }
            if (r1.begin >= r2.end) {
                return 1;
            }
            return 0;
        }
    }
}

