/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.x509.X509CertPath;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class ImportCmd
extends Command {
    private static final Logger log = Logger.getLogger(ImportCmd.class.getName());
    private static final String GKR = "gkr";
    private static final String JKS = "jks";
    private static final String LIB = "lib";
    private static final String SECURITY = "security";
    private static final String CACERTS = "cacerts";
    private static final String CACERTS_GKR = "cacerts.gkr";
    protected String _alias;
    protected String _certFileName;
    protected String _password;
    protected boolean noPrompt;
    protected boolean trustCACerts;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private CertificateFactory x509Factory;
    private String gkrCaCertsPathName;
    private String jksCaCertsPathName;
    private X509Certificate selfSignedCertificate;

    ImportCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setFile(String pathName) {
        this._certFileName = pathName;
    }

    public void setKeypass(String password) {
        this._password = password;
    }

    public void setNoprompt(String flag) {
        this.noPrompt = Boolean.valueOf(flag);
    }

    public void setTrustcacerts(String flag) {
        this.trustCACerts = Boolean.valueOf(flag);
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setInputStreamParam(this._certFileName);
        this.setKeyStoreParams(true, this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        if (Configuration.DEBUG) {
            log.fine("-import handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -file=" + this._certFileName);
            log.fine("  -noprompt=" + this.noPrompt);
            log.fine("  -trustcacerts=" + this.trustCACerts);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException, KeyStoreException, IOException, UnsupportedCallbackException, NoSuchAlgorithmException, CertPathValidatorException, UnrecoverableKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (this.trustCACerts) {
            String fs = SystemProperties.getProperty((String)"file.separator");
            String classpathHome = SystemProperties.getProperty((String)"gnu.classpath.home");
            this.gkrCaCertsPathName = classpathHome + fs + LIB + fs + SECURITY + fs + CACERTS_GKR;
            String javaHome = SystemProperties.getProperty((String)"java.home");
            this.jksCaCertsPathName = javaHome + fs + LIB + fs + SECURITY + fs + CACERTS;
        }
        this.x509Factory = CertificateFactory.getInstance("X.509");
        if (!this.store.containsAlias(this.alias)) {
            this.importNewTrustedCertificate();
        } else {
            this.ensureAliasIsKeyEntry();
            this.importCertificateReply();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("import", true);
        result.setHeader(Messages.getString("ImportCmd.27"));
        result.setFooter(Messages.getString("ImportCmd.26"));
        OptionGroup options = new OptionGroup(Messages.getString("ImportCmd.25"));
        options.add(new Option("alias", Messages.getString("ImportCmd.24"), Messages.getString("ImportCmd.23")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._alias = argument;
            }
        });
        options.add(new Option("file", Messages.getString("ImportCmd.22"), Messages.getString("ImportCmd.21")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._certFileName = argument;
            }
        });
        options.add(new Option("keypass", Messages.getString("ImportCmd.20"), Messages.getString("ImportCmd.19")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._password = argument;
            }
        });
        options.add(new Option("noprompt", Messages.getString("ImportCmd.18")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this.noPrompt = true;
            }
        });
        options.add(new Option("trustcacerts", Messages.getString("ImportCmd.17")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this.trustCACerts = true;
            }
        });
        options.add(new Option("storetype", Messages.getString("ImportCmd.16"), Messages.getString("ImportCmd.15")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("ImportCmd.14"), Messages.getString("ImportCmd.13")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("ImportCmd.12"), Messages.getString("ImportCmd.11")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("ImportCmd.10"), Messages.getString("ImportCmd.9")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("ImportCmd.8")){

            public void parsed(String argument) throws OptionException {
                ImportCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void importNewTrustedCertificate() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, CertPathValidatorException, UnrecoverableKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importNewTrustedCertificate");
        }
        Certificate certificate = this.x509Factory.generateCertificate(this.inStream);
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        LinkedList<Certificate> orderedReply = new LinkedList<Certificate>();
        orderedReply.addLast(certificate);
        if (this.findTrustAndUpdate(orderedReply, !this.noPrompt)) {
            this.store.setCertificateEntry(this.alias, certificate);
            System.out.println(Messages.getString("ImportCmd.29"));
            this.saveKeyStore();
        } else {
            System.out.println(Messages.getString("ImportCmd.28"));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importNewTrustedCertificate");
        }
    }

    private void importCertificateReply() throws CertificateException, IOException, UnsupportedCallbackException, KeyStoreException, NoSuchAlgorithmException, CertPathValidatorException, UnrecoverableKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importCertificateReply");
        }
        Collection<? extends Certificate> certificates = this.x509Factory.generateCertificates(this.inStream);
        this.ensureReplyIsOurs(certificates);
        if (certificates.size() == 1) {
            this.importCertificate(certificates.iterator().next());
        } else {
            this.importChain(certificates);
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importCertificateReply");
        }
    }

    private void importCertificate(Certificate certificate) throws NoSuchAlgorithmException, CertPathValidatorException, KeyStoreException, UnrecoverableKeyException, IOException, UnsupportedCallbackException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importCertificate", certificate);
        }
        LinkedList<Certificate> reply = new LinkedList<Certificate>();
        reply.addLast(certificate);
        if (!this.findTrustAndUpdate(reply, false)) {
            throw new CertPathValidatorException(Messages.getString("ImportCmd.34"));
        }
        Certificate[] newChain = reply.toArray(new Certificate[0]);
        Key privateKey = this.getAliasPrivateKey();
        this.store.setKeyEntry(this.alias, privateKey, this.keyPasswordChars, newChain);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importCertificate");
        }
    }

    private void importChain(Collection chain) throws NoSuchAlgorithmException, CertPathValidatorException, KeyStoreException, UnrecoverableKeyException, IOException, UnsupportedCallbackException, CertificateException {
        LinkedList reply;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "importChain", chain);
        }
        if (this.findTrustAndUpdate(reply = this.orderChain(chain), !this.noPrompt)) {
            Certificate[] newChain = reply.toArray(new Certificate[0]);
            Key privateKey = this.getAliasPrivateKey();
            this.store.setKeyEntry(this.alias, privateKey, this.keyPasswordChars, newChain);
            this.saveKeyStore();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "importChain");
        }
    }

    private void ensureReplyIsOurs(Collection certificates) throws IOException, UnsupportedCallbackException, KeyStoreException {
        boolean sameKey;
        Certificate[] chain;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "ensureReplyIsOurs");
        }
        Certificate certificate = (Certificate)certificates.iterator().next();
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        if ((chain = this.store.getCertificateChain(this.alias)) == null) {
            throw new IllegalArgumentException(Messages.getFormattedString("ImportCmd.37", this.alias));
        }
        this.selfSignedCertificate = (X509Certificate)chain[0];
        PublicKey anchorPublicKey = this.selfSignedCertificate.getPublicKey();
        PublicKey certPublicKey = certificate.getPublicKey();
        if (anchorPublicKey instanceof DSAPublicKey) {
            DSAPublicKey pk1 = (DSAPublicKey)anchorPublicKey;
            if (!(certPublicKey instanceof DSAPublicKey)) {
                throw new IllegalArgumentException(Messages.getString("ImportCmd.38"));
            }
            sameKey = this.areEqual(pk1, (DSAPublicKey)certPublicKey);
        } else if (anchorPublicKey instanceof RSAPublicKey) {
            RSAPublicKey pk1 = (RSAPublicKey)anchorPublicKey;
            if (!(certPublicKey instanceof RSAPublicKey)) {
                throw new IllegalArgumentException(Messages.getString("ImportCmd.38"));
            }
            sameKey = this.areEqual(pk1, (RSAPublicKey)certPublicKey);
        } else {
            throw new IllegalArgumentException(Messages.getFormattedString("ImportCmd.40", new String[]{this.alias, anchorPublicKey.getClass().getName()}));
        }
        if (!sameKey) {
            throw new IllegalArgumentException(Messages.getString("ImportCmd.41"));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "ensureReplyIsOurs");
        }
    }

    private boolean areEqual(DSAPublicKey pk1, DSAPublicKey pk2) {
        if (pk1.getY().compareTo(pk2.getY()) != 0) {
            return false;
        }
        DSAParams p1 = pk1.getParams();
        DSAParams p2 = pk2.getParams();
        if (p1.getG().compareTo(p2.getG()) != 0) {
            return false;
        }
        if (p1.getP().compareTo(p2.getP()) != 0) {
            return false;
        }
        return p1.getQ().compareTo(p2.getQ()) == 0;
    }

    private boolean areEqual(RSAPublicKey pk1, RSAPublicKey pk2) {
        if (pk1.getPublicExponent().compareTo(pk2.getPublicExponent()) != 0) {
            return false;
        }
        return pk1.getModulus().compareTo(pk2.getModulus()) == 0;
    }

    private LinkedList orderChain(Collection chain) {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "orderChain");
        }
        LinkedList in = new LinkedList(chain);
        int initialCount = in.size();
        LinkedList<X509Certificate> result = new LinkedList<X509Certificate>();
        Principal issuer = this.selfSignedCertificate.getIssuerDN();
        block0: while (in.size() > 0) {
            ListIterator it = in.listIterator();
            while (it.hasNext()) {
                X509Certificate certificate = (X509Certificate)it.next();
                if (!issuer.equals(certificate.getSubjectDN())) continue;
                it.remove();
                result.addLast(certificate);
                issuer = certificate.getIssuerDN();
                continue block0;
            }
            throw new IllegalArgumentException(Messages.getFormattedString(Messages.getString("ImportCmd.7"), new Object[]{result.size(), initialCount}));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "orderChain", result);
        }
        return result;
    }

    private boolean findTrustAndUpdate(LinkedList reply, boolean promptUser) throws IOException, NoSuchAlgorithmException, CertPathValidatorException, KeyStoreException, UnrecoverableKeyException, UnsupportedCallbackException, CertificateEncodingException {
        PKIXParameters params;
        CertPathValidator validator;
        X509CertPath certPath;
        PKIXCertPathValidatorResult cpvr;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "findTrustAndUpdate");
        }
        if ((cpvr = this.findTrustInStore(certPath = new X509CertPath((List)reply), validator = CertPathValidator.getInstance("PKIX"))) == null && this.trustCACerts && (cpvr = this.validate(validator, certPath, params = this.getCertPathParameters(GKR, this.gkrCaCertsPathName))) == null) {
            params = this.getCertPathParameters(JKS, this.jksCaCertsPathName);
            cpvr = this.validate(validator, certPath, params);
        }
        boolean result = false;
        if (cpvr == null) {
            if (promptUser) {
                this.printVerbose((Certificate)reply.getLast());
                ConfirmationCallback ccb = new ConfirmationCallback(Messages.getString("ImportCmd.32"), 0, 0, 1);
                this.getCallbackHandler().handle(new Callback[]{ccb});
                int answer = ccb.getSelectedIndex();
                result = answer == 0;
            }
        } else {
            TrustAnchor anchor = cpvr.getTrustAnchor();
            log.fine("Found a chain-of-trust anchored by " + anchor);
            X509Certificate trustedCert = anchor.getTrustedCert();
            reply.addLast(trustedCert);
            result = true;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "findTrustAndUpdate", result);
        }
        return result;
    }

    private PKIXCertPathValidatorResult findTrustInStore(X509CertPath certPath, CertPathValidator validator) {
        PKIXCertPathValidatorResult result;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "findTrustInStore");
        }
        try {
            PKIXParameters params = new PKIXParameters(this.store);
            result = (PKIXCertPathValidatorResult)validator.validate((CertPath)certPath, params);
        }
        catch (Exception x) {
            log.log(Level.FINE, "Exception in findTrustInStore(). Ignore + Return NULL", x);
            result = null;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "findTrustInStore", result);
        }
        return result;
    }

    private PKIXParameters getCertPathParameters(String type, String pathName) {
        PKIXParameters result;
        block17: {
            if (Configuration.DEBUG) {
                log.entering(this.getClass().getName(), "getCertPathParameters", new Object[]{type, pathName});
            }
            FileInputStream stream = null;
            result = null;
            try {
                try {
                    KeyStore cacerts = KeyStore.getInstance(type);
                    stream = new FileInputStream(pathName);
                    cacerts.load(stream, "changeit".toCharArray());
                    result = new PKIXParameters(cacerts);
                }
                catch (Exception x) {
                    if (Configuration.DEBUG) {
                        log.log(Level.FINE, "Exception in getCertPathParameters(). Ignore", x);
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getCertPathParameters", result);
        }
        return result;
    }

    private PKIXCertPathValidatorResult validate(CertPathValidator validator, X509CertPath certPath, PKIXParameters params) {
        PKIXCertPathValidatorResult result;
        block5: {
            if (Configuration.DEBUG) {
                log.entering(this.getClass().getName(), "validate");
            }
            result = null;
            if (params != null) {
                try {
                    result = (PKIXCertPathValidatorResult)validator.validate((CertPath)certPath, params);
                }
                catch (Exception x) {
                    if (!Configuration.DEBUG) break block5;
                    log.log(Level.FINE, "Exception in validate(). Ignore", x);
                }
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "validate", result);
        }
        return result;
    }
}

