/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NCO_H_
#define _SOPRANO_NCO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk2 {
    namespace Vocabulary {
        namespace NCO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#
             */
            NEPOMUK_EXPORT QUrl ncoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Affiliation 
             * 
             * Aggregates three properties defined in RFC2426. Originally 
             * all three were attached directly to a person. One person could 
             * have only one title and one role within one organization. This 
             * class is intended to lift this limitation. 
             */
            NEPOMUK_EXPORT QUrl Affiliation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#AudioIMAccount 
             * 
             * Deprecated in favour of nco:imCapabilityAudio. 
             */
            NEPOMUK_EXPORT QUrl AudioIMAccount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#BbsNumber 
             * 
             * A Bulletin Board System (BBS) phone number. Inspired by the 
             * (TYPE=bbsl) parameter of the TEL property as defined in RFC 
             * 2426 sec 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl BbsNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#CarPhoneNumber 
             * 
             * A car phone number. Inspired by the (TYPE=car) parameter of 
             * the TEL property as defined in RFC 2426 sec 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl CarPhoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#CellPhoneNumber 
             * 
             * A cellular phone number. Inspired by the (TYPE=cell) parameter 
             * of the TEL property as defined in RFC 2426 sec 3.3.1. Usually 
             * a cellular phone can accept voice calls as well as textual messages 
             * (SMS), therefore this class has two superclasses. 
             */
            NEPOMUK_EXPORT QUrl CellPhoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact 
             * 
             * A Contact. A piece of data that can provide means to identify 
             * or communicate with an entity. 
             */
            NEPOMUK_EXPORT QUrl Contact();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactGroup 
             * 
             * A group of Contacts. Could be used to express a group in an addressbook 
             * or on a contact list of an IM application. One contact can belong 
             * to many groups. 
             */
            NEPOMUK_EXPORT QUrl ContactGroup();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactList 
             * 
             * A contact list, this class represents an addressbook or a contact 
             * list of an IM application. Contacts inside a contact list can 
             * belong to contact groups. 
             */
            NEPOMUK_EXPORT QUrl ContactList();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactListDataObject 
             * 
             * An entity occuring on a contact list (usually interpreted as 
             * an nco:Contact) 
             */
            NEPOMUK_EXPORT QUrl ContactListDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactMedium 
             * 
             * A superclass for all contact media - ways to contact an entity 
             * represented by a Contact instance. Some of the subclasses of 
             * this class (the various kinds of telephone numbers and postal 
             * addresses) have been inspired by the values of the TYPE parameter 
             * of ADR and TEL properties defined in RFC 2426 sec. 3.2.1. and 
             * 3.3.1 respectively. Each value is represented by an appropriate 
             * subclass with two major exceptions TYPE=home and TYPE=work. 
             * They are to be expressed by the roles these contact media are 
             * attached to i.e. contact media with TYPE=home parameter are 
             * to be attached to the default role (nco:Contact or nco:PersonContact), 
             * whereas media with TYPE=work parameter should be attached 
             * to nco:Affiliation or nco:OrganizationContact. 
             */
            NEPOMUK_EXPORT QUrl ContactMedium();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#DomesticDeliveryAddress 
             * 
             * Domestic Delivery Addresse. Class inspired by TYPE=dom parameter 
             * of the ADR property defined in RFC 2426 sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl DomesticDeliveryAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#EmailAddress 
             * 
             * An email address. The recommended best practice is to use mailto: 
             * uris for instances of this class. 
             */
            NEPOMUK_EXPORT QUrl EmailAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#FaxNumber 
             * 
             * A fax number. Inspired by the (TYPE=fax) parameter of the TEL 
             * property as defined in RFC 2426 sec 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl FaxNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Gender 
             * 
             * Gender. Instances of this class may include male and female. 
             */
            NEPOMUK_EXPORT QUrl Gender();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMAccount 
             * 
             * An account in an Instant Messaging system. 
             */
            NEPOMUK_EXPORT QUrl IMAccount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMCapability 
             * 
             * Capabilities of a cetain IMAccount. 
             */
            NEPOMUK_EXPORT QUrl IMCapability();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusType 
             * 
             * The status type of an IMAccount. Based on the Connection_Presence_Type 
             * enumeration of the Telepathy project: http://telepathy.freedesktop.org/spec/Connection_Interface_Simple_Presence.html#Enum:Connection_Presence_Type 
             */
            NEPOMUK_EXPORT QUrl IMStatusType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeAvailable 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeAvailable();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeAway 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeAway();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeBusy 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeBusy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeExtendedAway 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeExtendedAway();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeHidden 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeHidden();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeOffline 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeOffline();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IMStatusTypeUnknown 
             */
            NEPOMUK_EXPORT QUrl IMStatusTypeUnknown();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#InternationalDeliveryAddress 
             * 
             * International Delivery Addresse. Class inspired by TYPE=intl 
             * parameter of the ADR property defined in RFC 2426 sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl InternationalDeliveryAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#IsdnNumber 
             * 
             * An ISDN phone number. Inspired by the (TYPE=isdn) parameter 
             * of the TEL property as defined in RFC 2426 sec 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl IsdnNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#MessagingNumber 
             * 
             * A number that can accept textual messages. 
             */
            NEPOMUK_EXPORT QUrl MessagingNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ModemNumber 
             * 
             * A modem phone number. Inspired by the (TYPE=modem) parameter 
             * of the TEL property as defined in RFC 2426 sec 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl ModemNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#OrganizationContact 
             * 
             * A Contact that denotes on Organization. 
             */
            NEPOMUK_EXPORT QUrl OrganizationContact();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PagerNumber 
             * 
             * A pager phone number. Inspired by the (TYPE=pager) parameter 
             * of the TEL property as defined in RFC 2426 sec 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl PagerNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ParcelDeliveryAddress 
             * 
             * Parcel Delivery Addresse. Class inspired by TYPE=parcel parameter 
             * of the ADR property defined in RFC 2426 sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl ParcelDeliveryAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PcsNumber 
             * 
             * Personal Communication Services Number. A class inspired 
             * by the TYPE=pcs parameter of the TEL property defined in RFC 
             * 2426 sec. 3.3.1 
             */
            NEPOMUK_EXPORT QUrl PcsNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PersonContact 
             * 
             * A Contact that denotes a Person. A person can have multiple Affiliations. 
             */
            NEPOMUK_EXPORT QUrl PersonContact();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PhoneNumber 
             * 
             * A telephone number. 
             */
            NEPOMUK_EXPORT QUrl PhoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PostalAddress 
             * 
             * A postal address. A class aggregating the various parts of a 
             * value for the 'ADR' property as defined in RFC 2426 Sec. 3.2.1. 
             */
            NEPOMUK_EXPORT QUrl PostalAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Role 
             * 
             * A role played by a contact. Contacts that denote people, can 
             * have many roles (e.g. see the hasAffiliation property and Affiliation 
             * class). Contacts that denote Organizations or other Agents 
             * usually have one role. Each role can introduce additional contact 
             * media. 
             */
            NEPOMUK_EXPORT QUrl Role();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#VideoIMAccount 
             * 
             * Deprecated in favour of nco:imCapabilityVideo. 
             */
            NEPOMUK_EXPORT QUrl VideoIMAccount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#VideoTelephoneNumber 
             * 
             * A Video telephone number. A class inspired by the TYPE=video 
             * parameter of the TEL property defined in RFC 2426 sec. 3.3.1 
             */
            NEPOMUK_EXPORT QUrl VideoTelephoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#VoicePhoneNumber 
             * 
             * A telephone number with voice communication capabilities. 
             * Class inspired by the TYPE=voice parameter of the TEL property 
             * defined in RFC 2426 sec. 3.3.1 
             */
            NEPOMUK_EXPORT QUrl VoicePhoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#addressLocation 
             * 
             * The geographical location of a postal address. 
             */
            NEPOMUK_EXPORT QUrl addressLocation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#belongsToGroup 
             * 
             * Links a Contact with a ContactGroup it belongs to. 
             */
            NEPOMUK_EXPORT QUrl belongsToGroup();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#birthDate 
             * 
             * Birth date of the object represented by this Contact. An equivalent 
             * of the 'BDAY' property as defined in RFC 2426 Sec. 3.1.5. 
             */
            NEPOMUK_EXPORT QUrl birthDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#blogUrl 
             * 
             * A Blog url. 
             */
            NEPOMUK_EXPORT QUrl blogUrl();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#contactGroupName 
             * 
             * The name of the contact group. This property was NOT defined 
             * in the VCARD standard. See documentation of the 'ContactGroup' 
             * class for 
             * details 
             */
            NEPOMUK_EXPORT QUrl contactGroupName();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#contactMediumComment 
             * 
             * A comment about the contact medium. (Deprecated in favor of 
             * nie:comment or nao:description - based on the context) 
             */
            NEPOMUK_EXPORT QUrl contactMediumComment();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#contactUID 
             * 
             * A value that represents a globally unique identifier corresponding 
             * to the individual or resource associated with the Contact. 
             * An equivalent of the 'UID' property defined in RFC 2426 Sec. 
             * 3.6.7 
             */
            NEPOMUK_EXPORT QUrl contactUID();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#containsContact 
             * 
             * A property used to group contacts into contact groups. This 
             * property was NOT defined in the VCARD standard. See documentation 
             * for the 
             * 'ContactList' class for details 
             */
            NEPOMUK_EXPORT QUrl containsContact();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#contributor 
             * 
             * An entity responsible for making contributions to the content 
             * of the InformationElement. 
             */
            NEPOMUK_EXPORT QUrl contributor();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#country 
             * 
             * A part of an address specyfing the country. Inspired by the seventh 
             * part of the value of the 'ADR' property as defined in RFC 2426, 
             * sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl country();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#creator 
             * 
             * Creator of an information element, an entity primarily responsible 
             * for the creation of the content of the data object. 
             */
            NEPOMUK_EXPORT QUrl creator();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#department 
             * 
             * Department. The organizational unit within the organization. 
             */
            NEPOMUK_EXPORT QUrl department();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#emailAddress 
             */
            NEPOMUK_EXPORT QUrl emailAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#end 
             * 
             * End datetime for the role, such as: the datetime of leaving a 
             * project or organization, datetime of ending employment, datetime 
             * of divorce. If absent or set to a date in the future, the role is 
             * currently active. 
             */
            NEPOMUK_EXPORT QUrl end();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#extendedAddress 
             * 
             * An extended part of an address. This field might be used to express 
             * parts of an address that aren't include in the name of the Contact 
             * but also aren't part of the actual location. Usually the streed 
             * address and following fields are enough for a postal letter 
             * to arrive. Examples may include ('University of California 
             * Campus building 45', 'Sears Tower 34th floor' etc.) Inspired 
             * by the second part of the value of the 'ADR' property as defined 
             * in RFC 2426, sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl extendedAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#female 
             * 
             * A Female 
             */
            NEPOMUK_EXPORT QUrl female();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#foafUrl 
             * 
             * The URL of the FOAF file. 
             */
            NEPOMUK_EXPORT QUrl foafUrl();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#fullname 
             * 
             * To specify the formatted text corresponding to the name of the 
             * object the Contact represents. An equivalent of the FN property 
             * as defined in RFC 2426 Sec. 3.1.1. 
             */
            NEPOMUK_EXPORT QUrl fullname();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#gender 
             * 
             * Gender of the given contact. 
             */
            NEPOMUK_EXPORT QUrl gender();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasAffiliation 
             * 
             * Links a PersonContact with an Affiliation. 
             */
            NEPOMUK_EXPORT QUrl hasAffiliation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasContactMedium 
             * 
             * A superProperty for all properties linking a Contact to an instance 
             * of a contact medium. 
             */
            NEPOMUK_EXPORT QUrl hasContactMedium();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasEmailAddress 
             * 
             * An address for electronic mail communication with the object 
             * specified by this contact. An equivalent of the 'EMAIL' property 
             * as defined in RFC 2426 Sec. 3.3.1. 
             */
            NEPOMUK_EXPORT QUrl hasEmailAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasIMAccount 
             * 
             * Indicates that an Instant Messaging account owned by an entity 
             * represented by this contact. 
             */
            NEPOMUK_EXPORT QUrl hasIMAccount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasIMCapability 
             * 
             * Indicates that an IMAccount has a certain capability. 
             */
            NEPOMUK_EXPORT QUrl hasIMCapability();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasLocation 
             * 
             * Geographical location of the contact. Inspired by the 'GEO' 
             * property specified in RFC 2426 Sec. 3.4.2 
             */
            NEPOMUK_EXPORT QUrl hasLocation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasPhoneNumber 
             * 
             * A number for telephony communication with the object represented 
             * by this Contact. An equivalent of the 'TEL' property defined 
             * in RFC 2426 Sec. 3.3.1 
             */
            NEPOMUK_EXPORT QUrl hasPhoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hasPostalAddress 
             * 
             * The default Address for a Contact. An equivalent of the 'ADR' 
             * property as defined in RFC 2426 Sec. 3.2.1. 
             */
            NEPOMUK_EXPORT QUrl hasPostalAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#hobby 
             * 
             * A hobby associated with a PersonContact. This property can 
             * be used to express hobbies and interests. 
             */
            NEPOMUK_EXPORT QUrl hobby();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imAccountType 
             * 
             * Type of the IM account. This may be the name of the service that 
             * provides the IM functionality. Examples might include Jabber, 
             * ICQ, MSN etc 
             */
            NEPOMUK_EXPORT QUrl imAccountType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imCapabilityAudio 
             */
            NEPOMUK_EXPORT QUrl imCapabilityAudio();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imCapabilityText 
             */
            NEPOMUK_EXPORT QUrl imCapabilityText();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imCapabilityVideo 
             */
            NEPOMUK_EXPORT QUrl imCapabilityVideo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imID 
             * 
             * Identifier of the IM account. Examples of such identifier might 
             * include ICQ UINs, Jabber IDs, Skype names etc. 
             */
            NEPOMUK_EXPORT QUrl imID();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imNickname 
             * 
             * A nickname attached to a particular IM Account. 
             */
            NEPOMUK_EXPORT QUrl imNickname();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imStatus 
             * 
             * Current status of the given IM account. When this property is 
             * set, the nco:imStatusType should also always be set. Applications 
             * should attempt to parse this property to determine the presence, 
             * only falling back to the nco:imStatusType property in the case 
             * that this property's value is unrecognised. Values for this 
             * property may include 'available', 'offline', 'busy' etc. 
             * The exact choice of them is unspecified, although it is recommended 
             * to follow the guidance of the Telepathy project when choosing 
             * a string identifier http://telepathy.freedesktop.org/spec/Connection_Interface_Simple_Presence.html#description 
             */
            NEPOMUK_EXPORT QUrl imStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imStatusMessage 
             * 
             * A feature common in most IM systems. A message left by the user 
             * for all his/her contacts to see. 
             */
            NEPOMUK_EXPORT QUrl imStatusMessage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#imStatusType 
             * 
             * Current status type of the given IM account. When this property 
             * is set, the nco:imStatus property should also always be set. 
             * Applications should attempt to parse the nco:imStatus property 
             * to determine the presence, only falling back to this property 
             * in the case that the nco:imStatus property's value is unrecognised. 
             */
            NEPOMUK_EXPORT QUrl imStatusType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#isAccessedBy 
             * 
             * Indicates the local IMAccount by which this IMAccount is accessed. 
             * This does not imply membership of a contact list. 
             */
            NEPOMUK_EXPORT QUrl isAccessedBy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#isBlocked 
             * 
             * Indicates that this IMAccount has been blocked. 
             */
            NEPOMUK_EXPORT QUrl isBlocked();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#key 
             * 
             * An encryption key attached to a contact. Inspired by the KEY 
             * property defined in RFC 2426 sec. 3.7.2 
             */
            NEPOMUK_EXPORT QUrl key();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#locality 
             * 
             * Locality or City. Inspired by the fourth part of the value of 
             * the 'ADR' property as defined in RFC 2426, sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl locality();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#logo 
             * 
             * Logo of a company. Inspired by the LOGO property defined in RFC 
             * 2426 sec. 3.5.3 
             */
            NEPOMUK_EXPORT QUrl logo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#male 
             * 
             * A Male 
             */
            NEPOMUK_EXPORT QUrl male();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#nameAdditional 
             * 
             * Additional given name of an object represented by this contact. 
             * See documentation for 'nameFamily' property for details. 
             */
            NEPOMUK_EXPORT QUrl nameAdditional();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#nameFamily 
             * 
             * The family name of an Object represented by this Contact. These 
             * applies to people that have more than one given name. The 'first' 
             * one is considered 'the' given name (see nameGiven) property. 
             * All additional ones are considered 'additional' names. The 
             * name inherited from parents is the 'family name'. e.g. For Dr. 
             * John Phil Paul Stevenson Jr. M.D. A.C.P. we have contact with: 
             * honorificPrefix: 'Dr.', nameGiven: 'John', nameAdditional: 
             * 'Phil', nameAdditional: 'Paul', nameFamily: 'Stevenson', 
             * honorificSuffix: 'Jr.', honorificSuffix: 'M.D.', honorificSuffix: 
             * 'A.C.P.'. These properties form an equivalent of the compound 
             * 'N' property as defined in RFC 2426 Sec. 3.1.2 
             */
            NEPOMUK_EXPORT QUrl nameFamily();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#nameGiven 
             * 
             * The given name for the object represented by this Contact. See 
             * documentation for 'nameFamily' property for details. 
             */
            NEPOMUK_EXPORT QUrl nameGiven();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#nameHonorificPrefix 
             * 
             * A prefix for the name of the object represented by this Contact. 
             * See documentation for the 'nameFamily' property for details. 
             */
            NEPOMUK_EXPORT QUrl nameHonorificPrefix();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#nameHonorificSuffix 
             * 
             * A suffix for the name of the Object represented by the given object. 
             * See documentation for the 'nameFamily' for details. 
             */
            NEPOMUK_EXPORT QUrl nameHonorificSuffix();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#nickname 
             * 
             * A nickname of the Object represented by this Contact. This is 
             * an equivalent of the 'NICKNAME' property as defined in RFC 2426 
             * Sec. 3.1.3. 
             */
            NEPOMUK_EXPORT QUrl nickname();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#note 
             * 
             * A note about the object represented by this Contact. An equivalent 
             * for the 'NOTE' property defined in RFC 2426 Sec. 3.6.2 
             */
            NEPOMUK_EXPORT QUrl note();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#org 
             * 
             * Name of an organization or a unit within an organization the 
             * object represented by a Contact is associated with. An equivalent 
             * of the 'ORG' property defined in RFC 2426 Sec. 3.5.5 
             */
            NEPOMUK_EXPORT QUrl org();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#phoneNumber 
             */
            NEPOMUK_EXPORT QUrl phoneNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#photo 
             * 
             * Photograph attached to a Contact. The DataObject referred 
             * to by this property is usually interpreted as an nfo:Image. 
             * Inspired by the PHOTO property defined in RFC 2426 sec. 3.1.4 
             */
            NEPOMUK_EXPORT QUrl photo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#pobox 
             * 
             * Post office box. This is the first part of the value of the 'ADR' 
             * property as defined in RFC 2426, sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl pobox();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#postalcode 
             * 
             * Postal Code. Inspired by the sixth part of the value of the 'ADR' 
             * property as defined in RFC 2426, sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl postalcode();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#publisher 
             * 
             * An entity responsible for making the InformationElement available. 
             */
            NEPOMUK_EXPORT QUrl publisher();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#publishesPresenceTo 
             * 
             * Indicates that this IMAccount publishes its presence information 
             * to the other IMAccount. 
             */
            NEPOMUK_EXPORT QUrl publishesPresenceTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#region 
             * 
             * Region. Inspired by the fifth part of the value of the 'ADR' property 
             * as defined in RFC 2426, sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl region();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#representative 
             * 
             * An object that represent an object represented by this Contact. 
             * Usually this property is used to link a Contact to an organization, 
             * to a contact to the representative of this organization the 
             * user directly interacts with. An equivalent for the 'AGENT' 
             * property defined in RFC 2426 Sec. 3.5.4 
             */
            NEPOMUK_EXPORT QUrl representative();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#requestedPresenceSubscriptionTo 
             * 
             * Indicates that this IMAccount has requested a subscription 
             * to the presence information of the other IMAccount. 
             */
            NEPOMUK_EXPORT QUrl requestedPresenceSubscriptionTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#role 
             * 
             * Role an object represented by this contact represents in the 
             * organization. This might include 'Programmer', 'Manager', 
             * 'Sales Representative'. Be careful to avoid confusion with 
             * the title property. An equivalent of the 'ROLE' property as 
             * defined in RFC 2426. Sec. 3.5.2. Note the difference between 
             * nco:Role class and nco:role property. 
             */
            NEPOMUK_EXPORT QUrl role();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#sound 
             * 
             * Sound clip attached to a Contact. The DataObject referred to 
             * by this property is usually interpreted as an nfo:Audio. Inspired 
             * by the SOUND property defined in RFC 2425 sec. 3.6.6. 
             */
            NEPOMUK_EXPORT QUrl sound();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#start 
             * 
             * Start datetime for the role, such as: the datetime of joining 
             * a project or organization, datetime of starting employment, 
             * datetime of marriage 
             */
            NEPOMUK_EXPORT QUrl start();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#streetAddress 
             * 
             * The streed address. Inspired by the third part of the value of 
             * the 'ADR' property as defined in RFC 2426, sec. 3.2.1 
             */
            NEPOMUK_EXPORT QUrl streetAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#title 
             * 
             * The official title the object represented by this contact in 
             * an organization. E.g. 'CEO', 'Director, Research and Development', 
             * 'Junior Software Developer/Analyst' etc. An equivalent of 
             * the 'TITLE' property defined in RFC 2426 Sec. 3.5.1 
             */
            NEPOMUK_EXPORT QUrl title();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#url 
             * 
             * A uniform resource locator associated with the given role of 
             * a Contact. Inspired by the 'URL' property defined in RFC 2426 
             * Sec. 3.6.8. 
             */
            NEPOMUK_EXPORT QUrl url();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#voiceMail 
             * 
             * Indicates if the given number accepts voice mail. (e.g. there 
             * is an answering machine). Inspired by TYPE=msg parameter of 
             * the TEL property defined in RFC 2426 sec. 3.3.1 
             */
            NEPOMUK_EXPORT QUrl voiceMail();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nco#websiteUrl 
             * 
             * A url of a website. 
             */
            NEPOMUK_EXPORT QUrl websiteUrl();
        }
    }
}

#endif
