# Contributing

Bundler welcomes contributions from *everyone*. While contributing, please follow the project [code of conduct](http://bundler.io/conduct.html), so that everyone can be included.

If you'd like to help make Bundler better, you totally rock! Here are some ways you can contribute:

  - by using prerelease versions (run `gem install bundler --pre`)
  - by [reporting bugs you encounter](https://github.com/bundler/bundler/issues/new)
  - by [suggesting new features](https://github.com/bundler/bundler-features/issues/new)
  - by adding to or editing [the Bundler documentation website](http://bundler.io) and [Bundler man pages](http://bundler.io/man/bundle.1.html)
  - by [checking issues for completeness](https://github.com/bundler/bundler/blob/master/DEVELOPMENT.md#bug-triage)
  - by closing issues that are not complete
  - by adding a failing test for reproducible [reported bugs](https://github.com/bundler/bundler/issues)
  - by reviewing [pull requests](https://github.com/bundler/bundler/pulls) and suggesting improvements
  - by improving existing code, including [suggestions from PullReview](https://www.pullreview.com/github/bundler/bundler/reviews/master)
  - by [writing code](https://github.com/bundler/bundler/blob/master/DEVELOPMENT.md) (no patch is too small! fix typos or bad whitespace)

If you need help getting started, check out the [DEVELOPMENT](https://github.com/bundler/bundler/blob/master/DEVELOPMENT.md) file for steps that will get you up and running.

Thanks for helping us make Bundler better.

# Troubleshooting

If you're having a problem, please see [ISSUES](https://github.com/bundler/bundler/blob/master/ISSUES.md) for troubleshooting steps and a guide for how to submit a ticket that will help us solve the problem you are having as quickly as possible.

# Requesting Features

Head on over to the [Bundler features](https://github.com/bundler/bundler-features) project, or any of the lists or channels listed below. Feature-wise we consider Bundler stable, so the core team does not tend to work on feature suggestions. Pull requests welcome though!

# Discussing Bundler

If you'd like to discuss features, ask questions, or just engage in general Bundler-focused discussion, please see the [#bundler](irc://irc.freenode.net/#bundler) IRC channel on Freenode, and the [Bundler mailing list](http://groups.google.com/group/ruby-bundler) on Google Groups.
