import dbus
import gobject
import gtk
import os

__name = 'Pidgin Status Changer'
__version = '0.01'
__author = "Natan 'whatah' Zohar"
__blurb = "Pidgin Status Changer will change the current status' message to reflect the song playing in mpd"
__class = "Pidjin"

# Specify status ID values
STATUS_AVAILABLE = 2
STATUS_AWAY = 5
STATUS_NAME="pympd"
class PidginTalker:
    def __init__(self):
        self.saved_statuses = {}
        bus = dbus.SessionBus()
        obj = bus.get_object("im.pidgin.purple.PurpleService", "/im/pidgin/purple/PurpleObject")
        self.purple = dbus.Interface(obj, "im.pidgin.purple.PurpleInterface")

        status = self.purple.PurpleSavedstatusFind(STATUS_NAME)
        if status > 0:
            self.status = status
        else:
            self.status = self.purple.PurpleSavedstatusSetNew(STATUS_NAME,
                    STATUS_AWAY)
        print self.status



    def change_status(self, message=""):
        status = self.purple.PurpleSavedstatusGetCurrent()
        kind = self.purple.PurpleSavedstatusGetType(status)
        self.purple.PurpleSavedstatusSetType(self.status, kind)
        self.purple.PurpleSavedstatusSetMessage(self.status, message)
        self.purple.PurpleSavedstatusActivate(self.status)

    def get_status(self):
        status = self.purple.PurpleSavedstatusGetCurrent()
        msg = self.purple.PurpleSavedstatusGetMessage(status)
        return msg

class Pidgin:

    # called when we load the plugin. we get passed the mainWindow, plugin menu
    # item as well as a connection to mpd.
    def _init(self, data, pympd):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, self.parser = data
        self.data = data
        self.pt = PidginTalker()
        self.old_state = None

    def _conf(self, hasConf=False):
        if hasConf:
            return False

    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        song = self.pympd.getCurrentSong()
        if data.state == 'play':
            if songChanged:
                msg = ""
                if song.artist and song.artist.strip() != "":
                    msg += song.artist
                if song.title and song.title.strip() != "":
                    msg += " - " + song.title
                gobject.idle_add(self.pt.change_status, msg)

        if data.state != self.old_state:
            if data.state == 'stop' or data.state == 'pause':
                msg = ""
                gobject.idle_add(self.pt.change_status)
            if data.state == 'play':
                msg = ""
                if song.artist and song.artist.strip() != "":
                    msg += song.artist
                if song.title and song.title.strip() != "":
                    msg += " - " + song.title
                gobject.idle_add(self.pt.change_status, msg)
            self.old_state = data.state
                
    # called on plugin unloaded
    def _unload(self):
        self.pt.change_status()
        return

# vim: set expandtab shiftwidth=4 softtabstop=4 textwidth=79:
