/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHistoryReferencesContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public abstract class PopupMenuItemHistoryReferenceContainer
extends PopupMenuItemHttpMessageContainer {
    private static final long serialVersionUID = -7860130362424758504L;

    public PopupMenuItemHistoryReferenceContainer(String string) {
        this(string, false);
    }

    public PopupMenuItemHistoryReferenceContainer(String string, boolean bl) {
        super(string, bl);
    }

    @Override
    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHistoryReferencesContainer || httpMessageContainer instanceof SingleHistoryReferenceContainer;
    }

    @Override
    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedHistoryReferences(this.getSelectedHistoryReferences(httpMessageContainer));
    }

    @Override
    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        Session session = Model.getSingleton().getSession();
        for (HistoryReference historyReference : this.getSelectedHistoryReferences(httpMessageContainer)) {
            if (historyReference == null || session.isInScope(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected List<HistoryReference> getSelectedHistoryReferences(HttpMessageContainer httpMessageContainer) {
        SingleHistoryReferenceContainer singleHistoryReferenceContainer;
        if (httpMessageContainer instanceof SelectableHistoryReferencesContainer) {
            return ((SelectableHistoryReferencesContainer)httpMessageContainer).getSelectedHistoryReferences();
        }
        if (httpMessageContainer instanceof SingleHistoryReferenceContainer && !(singleHistoryReferenceContainer = (SingleHistoryReferenceContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HistoryReference> arrayList = new ArrayList<HistoryReference>(1);
            arrayList.add(singleHistoryReferenceContainer.getHistoryReference());
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedHistoryReferences(List<HistoryReference> list) {
        for (HistoryReference historyReference : list) {
            if (historyReference == null || this.isButtonEnabledForHistoryReference(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        return historyReference.getHistoryType() != 0;
    }

    @Override
    protected final void performActions(HttpMessageContainer httpMessageContainer) {
        this.performHistoryReferenceActions(this.getSelectedHistoryReferences(httpMessageContainer));
    }

    @Override
    protected final void performActions(List<HttpMessage> list) {
    }

    @Override
    protected final void performAction(HttpMessage httpMessage) {
    }

    protected void performHistoryReferenceActions(List<HistoryReference> list) {
        for (HistoryReference historyReference : list) {
            if (historyReference == null) continue;
            this.performAction(historyReference);
        }
    }

    protected abstract void performAction(HistoryReference var1);
}

