/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.spider.filters.ParseFilter;

public class DefaultParseFilter
extends ParseFilter {
    public static final int MAX_RESPONSE_BODY_SIZE = 512000;
    private static final Pattern svnSQLiteFilenamePattern = Pattern.compile(".*/\\.svn/wc.db$");
    private static final Pattern svnXMLFilenamePattern = Pattern.compile(".*/\\.svn/entries$");
    private static final Pattern gitFilenamePattern = Pattern.compile(".*/\\.git/index$");

    @Override
    public boolean isFiltered(HttpMessage httpMessage) {
        try {
            String string = httpMessage.getRequestHeader().getURI().getPath();
            if (string == null) {
                string = "";
            }
            Matcher matcher = svnSQLiteFilenamePattern.matcher(string);
            Matcher matcher2 = svnXMLFilenamePattern.matcher(string);
            Matcher matcher3 = gitFilenamePattern.matcher(string);
            if (matcher.find() || matcher2.find() || matcher3.find()) {
                return false;
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException);
        }
        if (httpMessage.getResponseBody().length() > 512000) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource too large: " + httpMessage.getRequestHeader().getURI()));
            }
            return true;
        }
        if (HttpStatusCode.isRedirection(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (!httpMessage.getResponseHeader().isText()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource is not text: " + httpMessage.getRequestHeader().getURI()));
            }
            return true;
        }
        return false;
    }
}

