/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public abstract class PopupUserMenu
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 1608127089952566119L;
    private User user;
    private String parentMenuName;
    private Context context;

    public PopupUserMenu(Context context, User user, String string) {
        super(context.getName() + ": " + user.getName(), true);
        this.user = user;
        this.parentMenuName = string;
        this.context = context;
        if (!user.isEnabled()) {
            this.setText(this.getText() + " (disabled)");
        }
    }

    @Override
    protected boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        return this.user.isEnabled() && this.context.isInContext(siteNode);
    }

    @Override
    public String getParentMenuName() {
        return this.parentMenuName;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    protected boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        switch (invoker) {
            case ALERTS_PANEL: 
            case ACTIVE_SCANNER_PANEL: 
            case FORCED_BROWSE_PANEL: 
            case FUZZER_PANEL: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    public User getUser() {
        return this.user;
    }

    public Context getContext() {
        return this.context;
    }
}

