/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.ManualAuthenticationMethodType;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;
import org.zaproxy.zap.extension.stdmenus.PopupContextMenuItemFactory;
import org.zaproxy.zap.extension.users.ContextUsersPanel;
import org.zaproxy.zap.extension.users.DialogAddUser;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;

public class PopupMenuFactoryAddUserFromSession
extends PopupContextMenuItemFactory {
    private static final Logger log = Logger.getLogger(PopupMenuFactoryAddUserFromSession.class);
    private static final long serialVersionUID = 2453839120088204122L;
    private ExtensionHttpSessions extension;
    private ExtensionAuthentication extensionAuth;
    private ExtensionUserManagement extensionUsers;

    public PopupMenuFactoryAddUserFromSession(ExtensionHttpSessions extensionHttpSessions) {
        super(Constant.messages.getString("httpsessions.popup.session.addUser"));
        this.extension = extensionHttpSessions;
    }

    @Override
    public ExtensionPopupMenuItem getContextMenu(Context context, String string) {
        return new PopupMenuAddUserFromSession(context);
    }

    private ExtensionAuthentication getExtensionAuthentication() {
        if (this.extensionAuth == null) {
            this.extensionAuth = (ExtensionAuthentication)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAuthentication");
        }
        return this.extensionAuth;
    }

    private ExtensionUserManagement getExtensionUserManagement() {
        if (this.extensionUsers == null) {
            this.extensionUsers = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
        }
        return this.extensionUsers;
    }

    protected class PopupMenuAddUserFromSession
    extends ExtensionPopupMenuItem {
        private static final long serialVersionUID = 301409585294663964L;
        private Context context;
        private boolean pendingUsersClearing;
        private User newUser;

        @Override
        public boolean isSubMenu() {
            return true;
        }

        @Override
        public String getParentMenuName() {
            return Constant.messages.getString("httpsessions.popup.session.addUser");
        }

        public PopupMenuAddUserFromSession(Context context) {
            super(context.getName());
            this.context = context;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupMenuAddUserFromSession.this.performAction();
                }
            });
        }

        @Override
        public boolean isEnableForComponent(Component component) {
            if (PopupMenuFactoryAddUserFromSession.this.getExtensionAuthentication() == null) {
                return false;
            }
            if (PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement() == null) {
                return false;
            }
            return component.getName() != null && component.getName().equals("httpsessions");
        }

        @Override
        public int getParentMenuIndex() {
            return 1;
        }

        private boolean confirmUsersDeletion(Context context) {
            int n;
            return PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement() == null || PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement().getSharedContextUsers(context).size() <= 0 || (n = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2)) != 2;
        }

        private User showAddUserDialogue(Context context, HttpSession httpSession) {
            DialogAddUser dialogAddUser = null;
            if (dialogAddUser == null) {
                dialogAddUser = new DialogAddUserBasedOnSession(View.getSingleton().getOptionsDialog(null), PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement(), httpSession);
                dialogAddUser.pack();
            }
            dialogAddUser.setWorkingContext(context);
            dialogAddUser.setVisible(true);
            User user = dialogAddUser.getUser();
            dialogAddUser.clear();
            dialogAddUser.dispose();
            return user;
        }

        public void performAction() {
            SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
            sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
            final Context context = sessionDialog.getUISharedContext(this.context.getIndex());
            HttpSessionsPanel httpSessionsPanel = PopupMenuFactoryAddUserFromSession.this.extension.getHttpSessionsPanel();
            HttpSession httpSession = httpSessionsPanel.getSelectedSession();
            log.info((Object)("Creating user from HttpSession " + httpSession.getName() + " for Context " + context.getName()));
            this.pendingUsersClearing = false;
            if (!(context.getAuthenticationMethod() instanceof ManualAuthenticationMethodType.ManualAuthenticationMethod)) {
                log.info((Object)("Creating new Manual Authentication instance for Context " + context.getName()));
                ManualAuthenticationMethodType.ManualAuthenticationMethod manualAuthenticationMethod = new ManualAuthenticationMethodType().createAuthenticationMethod(this.context.getIndex());
                if (!this.confirmUsersDeletion(context)) {
                    log.debug((Object)"Cancelled change of authentication type.");
                    return;
                }
                context.setAuthenticationMethod(manualAuthenticationMethod);
                this.pendingUsersClearing = true;
            }
            this.newUser = this.showAddUserDialogue(context, httpSession);
            if (this.newUser == null) {
                log.debug((Object)"Cancelled creation of user from HttpSession.");
                return;
            }
            log.info((Object)("Created user: " + this.newUser.toString()));
            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextUsersPanel.getPanelName(this.context.getIndex()), false, new Runnable(){

                @Override
                public void run() {
                    if (PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement() != null) {
                        if (PopupMenuAddUserFromSession.this.pendingUsersClearing) {
                            PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement().removeSharedContextUsers(context);
                        }
                        PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement().addSharedContextUser(context, PopupMenuAddUserFromSession.this.newUser);
                    }
                }
            });
        }

        private class DialogAddUserBasedOnSession
        extends DialogAddUser {
            private static final long serialVersionUID = 2269873123657767822L;
            private HttpSession session;

            public DialogAddUserBasedOnSession(Dialog dialog, ExtensionUserManagement extensionUserManagement, HttpSession httpSession) {
                super(dialog, extensionUserManagement);
                this.session = httpSession;
            }

            @Override
            protected void init() {
                if (this.workingContext == null) {
                    throw new IllegalStateException("A working Context should be set before setting the 'Add Dialog' visible.");
                }
                this.configuredCredentials = ManualAuthenticationMethodType.createAuthenticationCredentials(this.session);
                this.getNameTextField().setText(this.session.getName());
                this.getEnabledCheckBox().setSelected(true);
                this.initializeCredentialsConfigPanel();
            }
        }
    }
}

