/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.ProxyExcludedDomainMatcher;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public class ConnectionParam
extends AbstractParam {
    private static Logger log = Logger.getLogger(ConnectionParam.class);
    private static final String CONNECTION_BASE_KEY = "connection";
    private static final String USE_PROXY_CHAIN_KEY = "connection.proxyChain.enabled";
    private static final String PROXY_CHAIN_NAME = "connection.proxyChain.hostName";
    private static final String PROXY_CHAIN_PORT = "connection.proxyChain.port";
    private static final String USE_PROXY_CHAIN_AUTH_KEY = "connection.proxyChain.authEnabled";
    private static final String PROXY_CHAIN_REALM = "connection.proxyChain.realm";
    private static final String PROXY_CHAIN_USER_NAME = "connection.proxyChain.userName";
    private static final String PROXY_CHAIN_PASSWORD = "connection.proxyChain.password";
    private static final String PROXY_EXCLUDED_DOMAIN_KEY = "connection.proxyChain.exclusions";
    private static final String ALL_PROXY_EXCLUDED_DOMAINS_KEY = "connection.proxyChain.exclusions.exclusion";
    private static final String PROXY_EXCLUDED_DOMAIN_VALUE_KEY = "name";
    private static final String PROXY_EXCLUDED_DOMAIN_REGEX_KEY = "regex";
    private static final String PROXY_EXCLUDED_DOMAIN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_EXCLUDED_DOMAIN = "connection.proxyChain.confirmRemoveExcludedDomain";
    private static final String SECURITY_PROTOCOLS_ENABLED = "connection.securityProtocolsEnabled";
    private static final String SECURITY_PROTOCOL_ELEMENT_KEY = "protocol";
    private static final String ALL_SECURITY_PROTOCOLS_ENABLED_KEY = "connection.securityProtocolsEnabled.protocol";
    private static final String PROXY_CHAIN_PROMPT = "connection.proxyChain.prompt";
    private static final String TIMEOUT_IN_SECS = "connection.timeoutInSecs";
    private static final String SINGLE_COOKIE_REQUEST_HEADER = "connection.singleCookieRequestHeader";
    private static final String DEFAULT_USER_AGENT = "connection.defaultUserAgent";
    private static final String DEFAULT_DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0";
    private boolean useProxyChain;
    private String proxyChainName = "";
    private int proxyChainPort = 8080;
    private boolean confirmRemoveProxyExcludeDomain = true;
    private boolean useProxyChainAuth;
    private String proxyChainRealm = "";
    private String proxyChainUserName = "";
    private String proxyChainPassword = "";
    private HttpState httpState = null;
    private boolean httpStateEnabled = false;
    private List<ProxyExcludedDomainMatcher> proxyExcludedDomains = new ArrayList<ProxyExcludedDomainMatcher>(0);
    private List<ProxyExcludedDomainMatcher> proxyExcludedDomainsEnabled = new ArrayList<ProxyExcludedDomainMatcher>(0);
    private String[] securityProtocolsEnabled;
    private boolean proxyChainPrompt = false;
    private int timeoutInSecs = 120;
    private boolean singleCookieRequestHeader = true;
    private String defaultUserAgent = "";

    public boolean isHttpStateEnabled() {
        return this.httpStateEnabled;
    }

    public void setHttpStateEnabled(boolean bl) {
        this.httpStateEnabled = bl;
        this.httpState = this.httpStateEnabled ? new HttpState() : null;
    }

    @Override
    protected void parse() {
        this.updateOptions();
        this.useProxyChain = this.getConfig().getBoolean(USE_PROXY_CHAIN_KEY, false);
        this.useProxyChainAuth = this.getConfig().getBoolean(USE_PROXY_CHAIN_AUTH_KEY, false);
        this.setProxyChainName(this.getConfig().getString(PROXY_CHAIN_NAME, ""));
        try {
            this.setProxyChainPort(this.getConfig().getInt(PROXY_CHAIN_PORT, 8080));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.loadProxyExcludedDomains();
        try {
            this.confirmRemoveProxyExcludeDomain = this.getConfig().getBoolean(CONFIRM_REMOVE_EXCLUDED_DOMAIN, true);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while loading the confirm excluded domain remove option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.setProxyChainRealm(this.getConfig().getString(PROXY_CHAIN_REALM, ""));
            this.setProxyChainUserName(this.getConfig().getString(PROXY_CHAIN_USER_NAME, ""));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        try {
            if (this.getConfig().getProperty(PROXY_CHAIN_PROMPT) instanceof String && ((String)this.getConfig().getProperty(PROXY_CHAIN_PROMPT)).isEmpty()) {
                this.setProxyChainPrompt(false);
            } else if (this.getConfig().getBoolean(PROXY_CHAIN_PROMPT, false)) {
                this.setProxyChainPrompt(true);
            } else {
                this.setProxyChainPrompt(false);
                this.setProxyChainPassword(this.getConfig().getString(PROXY_CHAIN_PASSWORD, ""));
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        try {
            this.setTimeoutInSecs(this.getConfig().getInt(TIMEOUT_IN_SECS, 20));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        try {
            this.singleCookieRequestHeader = this.getConfig().getBoolean(SINGLE_COOKIE_REQUEST_HEADER, true);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while loading the option singleCookieRequestHeader: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.defaultUserAgent = this.getConfig().getString(DEFAULT_USER_AGENT, DEFAULT_DEFAULT_USER_AGENT);
        }
        catch (Exception exception) {
            log.error((Object)("Error while loading the option defaultUserAgent: " + exception.getMessage()), (Throwable)exception);
            this.defaultUserAgent = DEFAULT_DEFAULT_USER_AGENT;
        }
        this.loadSecurityProtocolsEnabled();
    }

    private void updateOptions() {
        String string;
        if (this.getConfig().containsKey("connectionsslConnectPorts")) {
            this.getConfig().clearProperty("connectionsslConnectPorts");
        }
        if (this.getConfig().containsKey("connection.proxyChain.skipName")) {
            this.migrateOldSkipNameOption(this.getConfig().getString("connection.proxyChain.skipName", ""));
            this.getConfig().clearProperty("connection.proxyChain.skipName");
        }
        if (!this.getConfig().containsKey(USE_PROXY_CHAIN_KEY) && !(string = this.getConfig().getString(PROXY_CHAIN_NAME, "")).isEmpty()) {
            this.getConfig().setProperty(USE_PROXY_CHAIN_KEY, (Object)Boolean.TRUE);
        }
        if (!this.getConfig().containsKey(USE_PROXY_CHAIN_AUTH_KEY) && !(string = this.getConfig().getString(PROXY_CHAIN_USER_NAME, "")).isEmpty()) {
            this.getConfig().setProperty(USE_PROXY_CHAIN_AUTH_KEY, (Object)Boolean.TRUE);
        }
    }

    private void migrateOldSkipNameOption(String string) {
        List<ProxyExcludedDomainMatcher> list = ConnectionParam.convertOldSkipNameOption(string);
        if (!list.isEmpty()) {
            this.setProxyExcludedDomains(list);
        }
    }

    private static List<ProxyExcludedDomainMatcher> convertOldSkipNameOption(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProxyExcludedDomainMatcher> arrayList = new ArrayList<ProxyExcludedDomainMatcher>();
        for (String string2 : stringArray = string.split(";")) {
            String string3 = string2.trim();
            if (string3.isEmpty()) continue;
            if (string3.contains("*")) {
                string3 = string3.replace(".", "\\.").replace("*", ".*?");
                try {
                    Pattern pattern = Pattern.compile(string3, 2);
                    arrayList.add(new ProxyExcludedDomainMatcher(pattern));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)("Failed to migrate the excluded domain name: " + string2), (Throwable)illegalArgumentException);
                }
                continue;
            }
            arrayList.add(new ProxyExcludedDomainMatcher(string3));
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public boolean isUseProxyChain() {
        return this.useProxyChain;
    }

    public void setUseProxyChain(boolean bl) {
        if (bl && (this.getProxyChainName() == null || this.getProxyChainName().isEmpty())) {
            return;
        }
        this.useProxyChain = bl;
        this.getConfig().setProperty(USE_PROXY_CHAIN_KEY, (Object)this.useProxyChain);
    }

    public String getProxyChainName() {
        return this.proxyChainName;
    }

    public void setProxyChainName(String string) {
        if (string == null) {
            return;
        }
        this.proxyChainName = string.trim();
        if (string.isEmpty()) {
            this.setUseProxyChain(false);
        }
        this.getConfig().setProperty(PROXY_CHAIN_NAME, (Object)this.proxyChainName);
    }

    public int getProxyChainPort() {
        return this.proxyChainPort;
    }

    public void setProxyChainPort(int n) {
        this.proxyChainPort = n;
        this.getConfig().setProperty(PROXY_CHAIN_PORT, (Object)Integer.toString(this.proxyChainPort));
    }

    @Deprecated
    public String getProxyChainSkipName() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (ProxyExcludedDomainMatcher proxyExcludedDomainMatcher : this.proxyExcludedDomains) {
            if (proxyExcludedDomainMatcher.isRegex()) continue;
            stringBuilder.append(proxyExcludedDomainMatcher.getValue()).append(';');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public void setProxyChainSkipName(String string) {
        this.setProxyExcludedDomains(ConnectionParam.convertOldSkipNameOption(string));
    }

    public boolean isUseProxyChainAuth() {
        return this.useProxyChainAuth;
    }

    public void setUseProxyChainAuth(boolean bl) {
        if (bl && (this.getProxyChainUserName() == null || this.getProxyChainUserName().isEmpty())) {
            return;
        }
        this.useProxyChainAuth = bl;
        this.getConfig().setProperty(USE_PROXY_CHAIN_AUTH_KEY, (Object)this.useProxyChainAuth);
    }

    public String getProxyChainRealm() {
        return this.proxyChainRealm;
    }

    public void setProxyChainRealm(String string) {
        this.proxyChainRealm = string.trim();
        this.getConfig().setProperty(PROXY_CHAIN_REALM, (Object)this.proxyChainRealm);
    }

    public String getProxyChainUserName() {
        return this.proxyChainUserName;
    }

    public void setProxyChainUserName(String string) {
        this.proxyChainUserName = string.trim();
        this.getConfig().setProperty(PROXY_CHAIN_USER_NAME, (Object)this.proxyChainUserName);
    }

    public String getProxyChainPassword() {
        return this.proxyChainPassword.trim();
    }

    public void setProxyChainPassword(String string) {
        this.proxyChainPassword = string;
        this.getConfig().setProperty(PROXY_CHAIN_PASSWORD, (Object)this.proxyChainPassword);
    }

    public void setProxyChainPassword(String string, boolean bl) {
        if (bl) {
            this.setProxyChainPassword(string);
        } else {
            this.proxyChainPassword = string;
        }
    }

    public void setProxyChainPrompt(boolean bl) {
        this.proxyChainPrompt = bl;
        this.getConfig().setProperty(PROXY_CHAIN_PROMPT, (Object)this.proxyChainPrompt);
    }

    public boolean isProxyChainPrompt() {
        return this.proxyChainPrompt;
    }

    private boolean isDomainExcludedFromProxy(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (ProxyExcludedDomainMatcher proxyExcludedDomainMatcher : this.proxyExcludedDomainsEnabled) {
            if (!proxyExcludedDomainMatcher.matches(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseProxy(String string) {
        return this.isUseProxyChain() && !this.isDomainExcludedFromProxy(string);
    }

    public HttpState getHttpState() {
        return this.httpState;
    }

    public void setHttpState(HttpState httpState) {
        this.httpState = httpState;
    }

    public int getTimeoutInSecs() {
        return this.timeoutInSecs;
    }

    public void setTimeoutInSecs(int n) {
        this.timeoutInSecs = n;
        this.getConfig().setProperty(TIMEOUT_IN_SECS, (Object)this.timeoutInSecs);
    }

    public boolean isSingleCookieRequestHeader() {
        return this.singleCookieRequestHeader;
    }

    public void setSingleCookieRequestHeader(boolean bl) {
        this.singleCookieRequestHeader = bl;
        this.getConfig().setProperty(SINGLE_COOKIE_REQUEST_HEADER, (Object)bl);
    }

    public List<ProxyExcludedDomainMatcher> getProxyExcludedDomains() {
        return this.proxyExcludedDomains;
    }

    public List<ProxyExcludedDomainMatcher> getProxyExcludedDomainsEnabled() {
        return this.proxyExcludedDomainsEnabled;
    }

    public void setProxyExcludedDomains(List<ProxyExcludedDomainMatcher> list) {
        if (list == null || list.isEmpty()) {
            ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
            this.proxyExcludedDomains = Collections.emptyList();
            this.proxyExcludedDomainsEnabled = Collections.emptyList();
            return;
        }
        this.proxyExcludedDomains = new ArrayList<ProxyExcludedDomainMatcher>(list);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
        int n = list.size();
        ArrayList<ProxyExcludedDomainMatcher> arrayList = new ArrayList<ProxyExcludedDomainMatcher>(n);
        for (int i = 0; i < n; ++i) {
            String string = "connection.proxyChain.exclusions.exclusion(" + i + ").";
            ProxyExcludedDomainMatcher proxyExcludedDomainMatcher = list.get(i);
            this.getConfig().setProperty(string + PROXY_EXCLUDED_DOMAIN_VALUE_KEY, (Object)proxyExcludedDomainMatcher.getValue());
            this.getConfig().setProperty(string + PROXY_EXCLUDED_DOMAIN_REGEX_KEY, (Object)proxyExcludedDomainMatcher.isRegex());
            this.getConfig().setProperty(string + PROXY_EXCLUDED_DOMAIN_ENABLED_KEY, (Object)proxyExcludedDomainMatcher.isEnabled());
            if (!proxyExcludedDomainMatcher.isEnabled()) continue;
            arrayList.add(proxyExcludedDomainMatcher);
        }
        arrayList.trimToSize();
        this.proxyExcludedDomainsEnabled = arrayList;
    }

    private void loadProxyExcludedDomains() {
        List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
        this.proxyExcludedDomains = new ArrayList<ProxyExcludedDomainMatcher>(list.size());
        ArrayList<ProxyExcludedDomainMatcher> arrayList = new ArrayList<ProxyExcludedDomainMatcher>(list.size());
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            String string = hierarchicalConfiguration.getString(PROXY_EXCLUDED_DOMAIN_VALUE_KEY, "");
            if (string.isEmpty()) {
                log.warn((Object)"Failed to read an outgoing proxy excluded domain entry, required value is empty.");
                continue;
            }
            ProxyExcludedDomainMatcher proxyExcludedDomainMatcher = null;
            boolean bl = hierarchicalConfiguration.getBoolean(PROXY_EXCLUDED_DOMAIN_REGEX_KEY, false);
            if (bl) {
                try {
                    Pattern pattern = ProxyExcludedDomainMatcher.createPattern(string);
                    proxyExcludedDomainMatcher = new ProxyExcludedDomainMatcher(pattern);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)("Failed to read an outgoing proxy excluded domain entry with regex: " + string), (Throwable)illegalArgumentException);
                }
            } else {
                proxyExcludedDomainMatcher = new ProxyExcludedDomainMatcher(string);
            }
            if (proxyExcludedDomainMatcher == null) continue;
            proxyExcludedDomainMatcher.setEnabled(hierarchicalConfiguration.getBoolean(PROXY_EXCLUDED_DOMAIN_ENABLED_KEY, true));
            this.proxyExcludedDomains.add(proxyExcludedDomainMatcher);
            if (!proxyExcludedDomainMatcher.isEnabled()) continue;
            arrayList.add(proxyExcludedDomainMatcher);
        }
        arrayList.trimToSize();
        this.proxyExcludedDomainsEnabled = arrayList;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveProxyExcludedDomain() {
        return this.confirmRemoveProxyExcludeDomain;
    }

    @ZapApiIgnore
    public void setConfirmRemoveProxyExcludedDomain(boolean bl) {
        this.confirmRemoveProxyExcludeDomain = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_EXCLUDED_DOMAIN, (Object)this.confirmRemoveProxyExcludeDomain);
    }

    @ZapApiIgnore
    public String[] getSecurityProtocolsEnabled() {
        return Arrays.copyOf(this.securityProtocolsEnabled, this.securityProtocolsEnabled.length);
    }

    public void setSecurityProtocolsEnabled(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && !stringArray[n].isEmpty()) continue;
            throw new IllegalArgumentException("The parameter enabledProtocols must not contain null or empty elements.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        for (n = 0; n < stringArray.length; ++n) {
            String string = "connection.securityProtocolsEnabled.protocol(" + n + ")";
            this.getConfig().setProperty(string, (Object)stringArray[n]);
        }
        this.securityProtocolsEnabled = Arrays.copyOf(stringArray, stringArray.length);
        SSLConnector.setClientEnabledProtocols(stringArray);
    }

    private void loadSecurityProtocolsEnabled() {
        List list = this.getConfig().getList(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        if (list.size() != 0) {
            this.securityProtocolsEnabled = new String[list.size()];
            this.securityProtocolsEnabled = list.toArray(this.securityProtocolsEnabled);
            SSLConnector.setClientEnabledProtocols(this.securityProtocolsEnabled);
        } else {
            this.setSecurityProtocolsEnabled(SSLConnector.getClientEnabledProtocols());
        }
    }

    public String getDefaultUserAgent() {
        return this.defaultUserAgent;
    }

    public void setDefaultUserAgent(String string) {
        this.defaultUserAgent = string;
        this.getConfig().setProperty(DEFAULT_USER_AGENT, (Object)string);
    }
}

