/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jdesktop.swingx.BackgroundPaintable;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PainterPaint;
import org.jdesktop.swingx.util.GraphicsUtilities;
import org.jdesktop.swingx.util.PaintUtils;

public class JXButton
extends JButton
implements BackgroundPaintable {
    private ForegroundButton fgStamp;
    private Painter fgPainter;
    private PainterPaint fgPaint;
    private BackgroundButton bgStamp;
    private Painter bgPainter;
    private boolean paintBorderInsets = true;
    private Rectangle viewRect = new Rectangle();
    private Rectangle textRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();

    public JXButton() {
        this.init();
    }

    public JXButton(String text) {
        super(text);
        this.init();
    }

    public JXButton(Action a) {
        super(a);
        this.init();
    }

    public JXButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JXButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        this.fgStamp = new ForegroundButton();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        SwingXUtilities.installBackground(this, bg);
    }

    @Override
    public Painter getBackgroundPainter() {
        return this.bgPainter;
    }

    @Override
    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.bgPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getForegroundPainter() {
        return this.fgPainter;
    }

    public void setForegroundPainter(Painter p) {
        Painter old = this.getForegroundPainter();
        this.fgPainter = p;
        if (this.fgPainter == null) {
            this.fgPaint = null;
        } else {
            this.fgPaint = new PainterPaint<JXButton>(this.fgPainter, this);
            if (this.bgStamp == null) {
                this.bgStamp = new BackgroundButton();
            }
        }
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    @Override
    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    @Override
    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof CellRendererPane) {
            return BasicGraphicsUtils.getPreferredButtonSize(this.fgStamp, this.getIconTextGap());
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (this.fgPainter == null && this.bgPainter == null) {
            super.paintComponent(g);
        } else {
            if (this.fgPainter == null) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    this.paintWithoutForegroundPainter(g2d);
                }
                finally {
                    g2d.dispose();
                }
            }
            if (this.fgPainter instanceof AbstractPainter && ((AbstractPainter)this.fgPainter).getFilters().length > 0) {
                this.paintWithForegroundPainterWithFilters(g);
            } else {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    this.paintWithForegroundPainterWithoutFilters(g2d);
                }
                finally {
                    g2d.dispose();
                }
            }
        }
    }

    private void paintWithoutForegroundPainter(Graphics2D g2d) {
        if (this.bgPainter == null) {
            SwingUtilities.paintComponent(g2d, this.bgStamp, this, 0, 0, this.getWidth(), this.getHeight());
        } else {
            SwingXUtilities.paintBackground(this, g2d);
        }
        SwingUtilities.paintComponent(g2d, this.fgStamp, this, 0, 0, this.getWidth(), this.getHeight());
    }

    private void paintWithForegroundPainterWithoutFilters(Graphics2D g2d) {
        this.paintWithoutForegroundPainter(g2d);
        if (this.getText() != null && !this.getText().isEmpty()) {
            Insets i = this.getInsets();
            this.viewRect.x = i.left;
            this.viewRect.y = i.top;
            this.viewRect.width = this.getWidth() - (i.right + this.viewRect.x);
            this.viewRect.height = this.getHeight() - (i.bottom + this.viewRect.y);
            this.textRect.height = 0;
            this.textRect.width = 0;
            this.textRect.y = 0;
            this.textRect.x = 0;
            this.iconRect.height = 0;
            this.iconRect.width = 0;
            this.iconRect.y = 0;
            this.iconRect.x = 0;
            String text = SwingUtilities.layoutCompoundLabel(this, g2d.getFontMetrics(), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.getText() == null ? 0 : this.getIconTextGap());
            if (!this.isPaintBorderInsets()) {
                g2d.translate(i.left, i.top);
            }
            g2d.setPaint(this.fgPaint);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, this.getDisplayedMnemonicIndex(), this.textRect.x, this.textRect.y + g2d.getFontMetrics().getAscent());
        }
    }

    private void paintWithForegroundPainterWithFilters(Graphics g) {
        BufferedImage im = GraphicsUtilities.createCompatibleImage(this.getWidth(), this.getHeight());
        Graphics2D g2d = im.createGraphics();
        this.paintWithForegroundPainterWithoutFilters(g2d);
        for (BufferedImageOp filter : ((AbstractPainter)this.fgPainter).getFilters()) {
            im = filter.filter(im, null);
        }
        g.drawImage(im, 0, 0, this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.bgStamp != null) {
            this.bgStamp.updateUI();
        }
        if (this.fgStamp != null) {
            this.fgStamp.updateUI();
        }
    }

    private class ForegroundButton
    extends JButton {
        private ForegroundButton() {
        }

        @Override
        public Color getForeground() {
            if (JXButton.this.fgPainter == null) {
                return JXButton.this.getForeground();
            }
            return PaintUtils.setAlpha(JXButton.this.getForeground(), 0);
        }

        @Override
        public boolean isDefaultButton() {
            return JXButton.this.isDefaultButton();
        }

        @Override
        public Icon getDisabledIcon() {
            return JXButton.this.getDisabledIcon();
        }

        @Override
        public Icon getDisabledSelectedIcon() {
            return JXButton.this.getDisabledSelectedIcon();
        }

        @Override
        public int getDisplayedMnemonicIndex() {
            return JXButton.this.getDisplayedMnemonicIndex();
        }

        @Override
        public int getHorizontalAlignment() {
            return JXButton.this.getHorizontalAlignment();
        }

        @Override
        public int getHorizontalTextPosition() {
            return JXButton.this.getHorizontalTextPosition();
        }

        @Override
        public Icon getIcon() {
            return JXButton.this.getIcon();
        }

        @Override
        public int getIconTextGap() {
            return JXButton.this.getIconTextGap();
        }

        @Override
        public Insets getMargin() {
            return JXButton.this.getMargin();
        }

        @Override
        public int getMnemonic() {
            return JXButton.this.getMnemonic();
        }

        @Override
        public ButtonModel getModel() {
            return JXButton.this.getModel();
        }

        @Override
        public Icon getPressedIcon() {
            return JXButton.this.getPressedIcon();
        }

        @Override
        public Icon getRolloverIcon() {
            return JXButton.this.getRolloverIcon();
        }

        @Override
        public Icon getRolloverSelectedIcon() {
            return JXButton.this.getRolloverSelectedIcon();
        }

        @Override
        public Icon getSelectedIcon() {
            return JXButton.this.getSelectedIcon();
        }

        @Override
        public String getText() {
            return JXButton.this.getText();
        }

        @Override
        public int getVerticalAlignment() {
            return JXButton.this.getVerticalAlignment();
        }

        @Override
        public int getVerticalTextPosition() {
            return JXButton.this.getVerticalTextPosition();
        }

        @Override
        public boolean isBorderPainted() {
            return JXButton.this.isBorderPainted();
        }

        @Override
        public boolean isContentAreaFilled() {
            return false;
        }

        @Override
        public boolean hasFocus() {
            return JXButton.this.hasFocus();
        }

        @Override
        public boolean isFocusPainted() {
            return JXButton.this.isFocusPainted();
        }

        @Override
        public boolean isRolloverEnabled() {
            return JXButton.this.isRolloverEnabled();
        }

        @Override
        public boolean isSelected() {
            return JXButton.this.isSelected();
        }
    }

    private class BackgroundButton
    extends JButton {
        private BackgroundButton() {
        }

        @Override
        public boolean isDefaultButton() {
            return JXButton.this.isDefaultButton();
        }

        @Override
        public Icon getDisabledIcon() {
            return null;
        }

        @Override
        public Icon getDisabledSelectedIcon() {
            return null;
        }

        @Override
        public int getDisplayedMnemonicIndex() {
            return -1;
        }

        @Override
        public int getHorizontalAlignment() {
            return JXButton.this.getHorizontalAlignment();
        }

        @Override
        public int getHorizontalTextPosition() {
            return JXButton.this.getHorizontalTextPosition();
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public int getIconTextGap() {
            return JXButton.this.getIconTextGap();
        }

        @Override
        public Insets getMargin() {
            return JXButton.this.getMargin();
        }

        @Override
        public int getMnemonic() {
            return -1;
        }

        @Override
        public ButtonModel getModel() {
            return JXButton.this.getModel();
        }

        @Override
        public Icon getPressedIcon() {
            return null;
        }

        @Override
        public Icon getRolloverIcon() {
            return null;
        }

        @Override
        public Icon getRolloverSelectedIcon() {
            return null;
        }

        @Override
        public Icon getSelectedIcon() {
            return null;
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public int getVerticalAlignment() {
            return JXButton.this.getVerticalAlignment();
        }

        @Override
        public int getVerticalTextPosition() {
            return JXButton.this.getVerticalTextPosition();
        }

        @Override
        public boolean isBorderPainted() {
            return JXButton.this.isBorderPainted();
        }

        @Override
        public boolean isContentAreaFilled() {
            return JXButton.this.isContentAreaFilled();
        }

        @Override
        public boolean isFocusPainted() {
            return false;
        }

        @Override
        public boolean isRolloverEnabled() {
            return JXButton.this.isRolloverEnabled();
        }

        @Override
        public boolean isSelected() {
            return JXButton.this.isSelected();
        }
    }
}

