/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.tools.jline.internal.Configuration;
import scala.tools.jline.internal.Log;

public final class TerminalLineSettings {
    public static final String JLINE_STTY = "jline.stty";
    public static final String DEFAULT_STTY = "stty";
    public static final String JLINE_SH = "jline.sh";
    public static final String DEFAULT_SH = "sh";
    private static String sttyCommand = Configuration.getString("jline.stty", "stty");
    private static String shCommand = Configuration.getString("jline.sh", "sh");
    private String config = this.get("-a");
    private long configLastFetched = System.currentTimeMillis();

    public TerminalLineSettings() throws IOException, InterruptedException {
        Log.debug("Config: ", this.config);
        if (this.config.length() == 0) {
            throw new IOException(MessageFormat.format("Unrecognized stty code: {0}", this.config));
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void restore() throws IOException, InterruptedException {
        this.set("sane");
    }

    public String get(String string) throws IOException, InterruptedException {
        return TerminalLineSettings.stty(string);
    }

    public void set(String string) throws IOException, InterruptedException {
        TerminalLineSettings.stty(string);
    }

    public int getProperty(String string) {
        assert (string != null);
        try {
            if (this.config == null || System.currentTimeMillis() - this.configLastFetched > 1000L) {
                this.config = this.get("-a");
                this.configLastFetched = System.currentTimeMillis();
            }
            return this.getProperty(string, this.config);
        }
        catch (Exception exception) {
            Log.warn("Failed to query stty ", string, exception);
            return -1;
        }
    }

    protected int getProperty(String string, String string2) {
        Pattern pattern = Pattern.compile(string + "\\s+=\\s+([^;]*)[;\\n\\r]");
        Matcher matcher = pattern.matcher(string2);
        if (!(matcher.find() || (matcher = (pattern = Pattern.compile(string + "\\s+([^;]*)[;\\n\\r]")).matcher(string2)).find() || (matcher = (pattern = Pattern.compile("(\\S*)\\s+" + string)).matcher(string2)).find())) {
            return -1;
        }
        return this.parseControlChar(matcher.group(1));
    }

    private int parseControlChar(String string) {
        if ("<undef>".equals(string)) {
            return -1;
        }
        if (string.charAt(0) == '0') {
            return Integer.parseInt(string, 8);
        }
        if (string.charAt(0) >= '1' && string.charAt(0) <= '9') {
            return Integer.parseInt(string, 10);
        }
        if (string.charAt(0) == '^') {
            if (string.charAt(1) == '?') {
                return 127;
            }
            return string.charAt(1) - 64;
        }
        if (string.charAt(0) == 'M' && string.charAt(1) == '-') {
            if (string.charAt(2) == '^') {
                if (string.charAt(3) == '?') {
                    return 255;
                }
                return string.charAt(3) - 64 + 128;
            }
            return string.charAt(2) + 128;
        }
        return string.charAt(0);
    }

    private static String stty(String string) throws IOException, InterruptedException {
        assert (string != null);
        return TerminalLineSettings.exec(String.format("%s %s < /dev/tty", sttyCommand, string));
    }

    private static String exec(String string) throws IOException, InterruptedException {
        assert (string != null);
        return TerminalLineSettings.exec(shCommand, "-c", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exec(String ... stringArray) throws IOException, InterruptedException {
        assert (stringArray != null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Log.trace("Running: ", stringArray);
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream2 = process.getErrorStream();
            while ((n = inputStream2.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            outputStream = process.getOutputStream();
            process.waitFor();
        }
        catch (Throwable throwable) {
            TerminalLineSettings.close(inputStream, outputStream, inputStream2);
            throw throwable;
        }
        TerminalLineSettings.close(inputStream, outputStream, inputStream2);
        String string = byteArrayOutputStream.toString();
        Log.trace("Result: ", string);
        return string;
    }

    private static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

