/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.vob;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.jffmpeg.GPLLicense;

class DataBuffer
implements GPLLicense {
    protected byte[] buffer = new byte[10000];
    protected int size = 0;

    DataBuffer() {
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final int getCurrentSize() {
        return this.size;
    }

    public void readData(long l, InputStream inputStream, int n) throws IOException {
        if (this.buffer.length < n + this.size) {
            byte[] byArray = new byte[(n + this.size) * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.size);
            this.buffer = byArray;
        }
        int n2 = this.size;
        int n3 = 0;
        while (n > 0) {
            n3 = inputStream.read(this.buffer, this.size, n);
            if (n3 < 0) {
                throw new IOException("End of Stream");
            }
            n -= n3;
            this.size += n3;
        }
    }

    public void resetBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.size = 0;
    }

    public void setBuffer(byte[] byArray, int n) {
        this.buffer = byArray;
        this.size = n;
    }

    public void bufferData() throws IOException {
    }

    public void drop() {
        this.size = 0;
    }
}

