/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.vob;

import java.io.IOException;
import java.io.InputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import net.sourceforge.jffmpeg.GPLLicense;
import net.sourceforge.jffmpeg.demux.vob.DataBuffer;
import net.sourceforge.jffmpeg.demux.vob.VobDemux;

public class AudioTrack
extends DataBuffer
implements Track,
GPLLicense {
    VobDemux demux;
    int streamNumber;
    boolean enabled = true;
    public static final int[] halfRate = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3};
    public static final int[] rate = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 448, 512, 576, 640};
    private int offset = 0;
    private int sample_rate;
    private int frame_length;
    private long time = 0L;
    private volatile long timeStamp;

    public AudioTrack(VobDemux vobDemux, int n) {
        this.demux = vobDemux;
        this.streamNumber = n;
    }

    public Time getDuration() {
        System.out.println("Get Duration");
        return new Time(500L);
    }

    public Format getFormat() {
        return new AudioFormat("ac3", 48000.0, 16, 2, 0, 1);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Time mapFrameToTime(int n) {
        System.out.println("Map Frame To Time");
        return new Time((long)n);
    }

    public int mapTimeToFrame(Time time) {
        System.out.println("Map Time to Frame");
        return 0;
    }

    public void readFrame(Buffer buffer) {
        try {
            this.demux.readAudio(this.streamNumber, buffer);
            if (!this.enabled) {
                buffer.setLength(0);
            }
            if (this.timeStamp != 0L) {
                this.demux.setAudioTimeStamp(this.timeStamp);
            }
            this.timeStamp = 0L;
            byte[] byArray = (byte[])buffer.getData();
            int n = buffer.getLength();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Time getStartTime() {
        System.out.println("Get Start time");
        return new Time(2000L);
    }

    public void setTrackListener(TrackListener trackListener) {
    }

    public void readData(long l, InputStream inputStream, int n) throws IOException {
        super.readData(l, inputStream, n);
        if (this.timeStamp == 0L) {
            this.timeStamp = l;
        }
    }
}

