/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.ac3;

import javax.media.Buffer;
import net.sourceforge.jffmpeg.GPLLicense;

public class SoundOutput
implements GPLLicense {
    public static final double volumeControl = 16384.0 * Math.sqrt(2.0);
    public static final boolean debug = false;
    private static final int[] bit_reverse_512 = new int[]{0, 64, 32, 96, 16, 80, 48, 112, 8, 72, 40, 104, 24, 88, 56, 120, 4, 68, 36, 100, 20, 84, 52, 116, 12, 76, 44, 108, 28, 92, 60, 124, 2, 66, 34, 98, 18, 82, 50, 114, 10, 74, 42, 106, 26, 90, 58, 122, 6, 70, 38, 102, 22, 86, 54, 118, 14, 78, 46, 110, 30, 94, 62, 126, 1, 65, 33, 97, 17, 81, 49, 113, 9, 73, 41, 105, 25, 89, 57, 121, 5, 69, 37, 101, 21, 85, 53, 117, 13, 77, 45, 109, 29, 93, 61, 125, 3, 67, 35, 99, 19, 83, 51, 115, 11, 75, 43, 107, 27, 91, 59, 123, 7, 71, 39, 103, 23, 87, 55, 119, 15, 79, 47, 111, 31, 95, 63, 127};
    private static final int[] bit_reverse_256 = new int[]{0, 32, 16, 48, 8, 40, 24, 56, 4, 36, 20, 52, 12, 44, 28, 60, 2, 34, 18, 50, 10, 42, 26, 58, 6, 38, 22, 54, 14, 46, 30, 62, 1, 33, 17, 49, 9, 41, 25, 57, 5, 37, 21, 53, 13, 45, 29, 61, 3, 35, 19, 51, 11, 43, 27, 59, 7, 39, 23, 55, 15, 47, 31, 63};
    private static final double[] window = new double[]{1.4E-4, 2.4E-4, 3.7E-4, 5.1E-4, 6.7E-4, 8.6E-4, 0.00107, 0.0013, 0.00157, 0.00187, 0.0022, 0.00256, 0.00297, 0.00341, 0.0039, 0.00443, 0.00501, 0.00564, 0.00632, 0.00706, 0.00785, 0.00871, 0.00962, 0.01061, 0.01166, 0.01279, 0.01399, 0.01526, 0.01662, 0.01806, 0.01959, 0.02121, 0.02292, 0.02472, 0.02662, 0.02863, 0.03073, 0.03294, 0.03527, 0.0377, 0.04025, 0.04292, 0.04571, 0.04862, 0.05165, 0.05481, 0.0581, 0.06153, 0.06508, 0.06878, 0.07261, 0.07658, 0.08069, 0.08495, 0.08935, 0.09389, 0.09859, 0.10343, 0.10842, 0.11356, 0.11885, 0.12429, 0.12988, 0.13563, 0.14152, 0.14757, 0.15376, 0.16011, 0.16661, 0.17325, 0.18005, 0.18699, 0.19407, 0.2013, 0.20867, 0.21618, 0.22382, 0.23161, 0.23952, 0.24757, 0.25574, 0.26404, 0.27246, 0.281, 0.28965, 0.29841, 0.30729, 0.31626, 0.32533, 0.3345, 0.34376, 0.35311, 0.36253, 0.37204, 0.38161, 0.39126, 0.40096, 0.41072, 0.42054, 0.4304, 0.4403, 0.45023, 0.4602, 0.47019, 0.4802, 0.49022, 0.50025, 0.51028, 0.52031, 0.53033, 0.54033, 0.55031, 0.56026, 0.57019, 0.58007, 0.58991, 0.5997, 0.60944, 0.61912, 0.62873, 0.63827, 0.64774, 0.65713, 0.66643, 0.67564, 0.68476, 0.69377, 0.70269, 0.7115, 0.72019, 0.72877, 0.73723, 0.74557, 0.75378, 0.76186, 0.76981, 0.77762, 0.7853, 0.79283, 0.80022, 0.80747, 0.81457, 0.82151, 0.82831, 0.83496, 0.84145, 0.84779, 0.85398, 0.86001, 0.86588, 0.8716, 0.87716, 0.88257, 0.88782, 0.89291, 0.89785, 0.90264, 0.90728, 0.91176, 0.9161, 0.92028, 0.92432, 0.92822, 0.93197, 0.93558, 0.93906, 0.9424, 0.9456, 0.94867, 0.95162, 0.95444, 0.95713, 0.95971, 0.96217, 0.96451, 0.96674, 0.96887, 0.97089, 0.97281, 0.97463, 0.97635, 0.97799, 0.97953, 0.98099, 0.98236, 0.98366, 0.98488, 0.98602, 0.9871, 0.98811, 0.98905, 0.98994, 0.99076, 0.99153, 0.99225, 0.99291, 0.99353, 0.99411, 0.99464, 0.99513, 0.99558, 0.996, 0.99639, 0.99674, 0.99706, 0.99736, 0.99763, 0.99788, 0.99811, 0.99831, 0.9985, 0.99867, 0.99882, 0.99895, 0.99908, 0.99919, 0.99929, 0.99938, 0.99946, 0.99953, 0.99959, 0.99965, 0.99969, 0.99974, 0.99978, 0.99981, 0.99984, 0.99986, 0.99988, 0.9999, 0.99992, 0.99993, 0.99994, 0.99995, 0.99996, 0.99997, 0.99998, 0.99998, 0.99998, 0.99999, 0.99999, 0.99999, 0.99999, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private double[] buf_re = new double[128];
    private double[] buf_im = new double[128];
    private double[] buf_1_re = new double[64];
    private double[] buf_1_im = new double[64];
    private double[] buf_2_re = new double[64];
    private double[] buf_2_im = new double[64];
    private double[] xcos1 = new double[128];
    private double[] xsin1 = new double[128];
    private double[] xcos2 = new double[64];
    private double[] xsin2 = new double[64];
    private double[][] w_re = new double[8][256];
    private double[][] w_im = new double[8][256];

    private final void swap_cmplx(double[] dArray, double[] dArray2, int n, int n2) {
        double d = dArray[n];
        double d2 = dArray2[n];
        dArray[n] = dArray[n2];
        dArray2[n] = dArray2[n2];
        dArray[n2] = d;
        dArray2[n2] = d2;
    }

    public void a52_imdct_512(double[] dArray, int n, int n2, double d) {
        int n3;
        double d2;
        double d3;
        int n4;
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < 128; ++n7) {
            this.buf_re[n7] = dArray[n + 256 - 2 * n7 - 1] * this.xcos1[n7] - dArray[n + 2 * n7] * this.xsin1[n7];
            this.buf_im[n7] = -1.0 * (dArray[n + 2 * n7] * this.xcos1[n7] + dArray[n + 256 - 2 * n7 - 1] * this.xsin1[n7]);
        }
        for (n7 = 0; n7 < 128; ++n7) {
            n6 = bit_reverse_512[n7];
            if (n6 >= n7) continue;
            this.swap_cmplx(this.buf_re, this.buf_im, n7, n6);
        }
        for (n7 = 0; n7 < 7; ++n7) {
            int n8 = n7 != 0 ? 1 << n7 : 1;
            int n9 = 1 << n7 + 1;
            for (n5 = 0; n5 < n8; ++n5) {
                for (n4 = 0; n4 < 128; n4 += n9) {
                    n6 = n5 + n4;
                    int n10 = n6 + n8;
                    d3 = this.buf_re[n6];
                    d2 = this.buf_im[n6];
                    double d4 = this.buf_re[n10] * this.w_re[n7][n5] - this.buf_im[n10] * this.w_im[n7][n5];
                    double d5 = this.buf_im[n10] * this.w_re[n7][n5] + this.buf_re[n10] * this.w_im[n7][n5];
                    this.buf_re[n6] = d3 + d4;
                    this.buf_im[n6] = d2 + d5;
                    this.buf_re[n10] = d3 - d4;
                    this.buf_im[n10] = d2 - d5;
                }
            }
        }
        for (n5 = 0; n5 < 128; ++n5) {
            d3 = this.buf_re[n5];
            d2 = -1.0 * this.buf_im[n5];
            this.buf_re[n5] = d3 * this.xcos1[n5] - d2 * this.xsin1[n5];
            this.buf_im[n5] = d3 * this.xsin1[n5] + d2 * this.xcos1[n5];
        }
        n5 = n;
        n4 = n2;
        int n11 = 0;
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n5++] = -this.buf_im[64 + n3] * window[n11++] + dArray[n4++] + d;
            dArray[n5++] = this.buf_re[64 - n3 - 1] * window[n11++] + dArray[n4++] + d;
        }
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n5++] = -this.buf_re[n3] * window[n11++] + dArray[n4++] + d;
            dArray[n5++] = this.buf_im[128 - n3 - 1] * window[n11++] + dArray[n4++] + d;
        }
        n4 = n2;
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n4++] = -this.buf_re[64 + n3] * window[--n11];
            dArray[n4++] = this.buf_im[64 - n3 - 1] * window[--n11];
        }
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n4++] = this.buf_im[n3] * window[--n11];
            dArray[n4++] = -this.buf_re[128 - n3 - 1] * window[--n11];
        }
    }

    public void a52_imdct_256(double[] dArray, int n, int n2, double d) {
        double d2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < 64; ++n8) {
            n7 = 2 * (128 - 2 * n8 - 1);
            int n9 = 2 * (2 * n8);
            this.buf_1_re[n8] = dArray[n7] * this.xcos2[n8] - dArray[n9] * this.xsin2[n8];
            this.buf_1_im[n8] = -1.0 * (dArray[n9] * this.xcos2[n8] + dArray[n7] * this.xsin2[n8]);
            this.buf_2_re[n8] = dArray[n7 + 1] * this.xcos2[n8] - dArray[n9 + 1] * this.xsin2[n8];
            this.buf_2_im[n8] = -1.0 * (dArray[n9 + 1] * this.xcos2[n8] + dArray[n7 + 1] * this.xsin2[n8]);
        }
        for (n8 = 0; n8 < 64; ++n8) {
            n7 = bit_reverse_256[n8];
            if (n7 >= n8) continue;
            this.swap_cmplx(this.buf_1_re, this.buf_1_im, n8, n7);
            this.swap_cmplx(this.buf_2_re, this.buf_2_im, n8, n7);
        }
        for (n6 = 0; n6 < 6; ++n6) {
            n8 = 1 << n6;
            n7 = 1 << n6 + 1;
            n8 = n6 != 0 ? 1 << n6 : 1;
            for (n5 = 0; n5 < n8; ++n5) {
                for (n4 = 0; n4 < 64; n4 += n7) {
                    n3 = n5 + n4;
                    int n10 = n3 + n8;
                    double d3 = this.buf_1_re[n3];
                    d2 = this.buf_1_im[n3];
                    double d4 = this.buf_1_re[n10] * this.w_re[n6][n5] - this.buf_1_im[n10] * this.w_im[n6][n5];
                    double d5 = this.buf_1_im[n10] * this.w_re[n6][n5] + this.buf_1_re[n10] * this.w_im[n6][n5];
                    this.buf_1_re[n3] = d3 + d4;
                    this.buf_1_im[n3] = d2 + d5;
                    this.buf_1_re[n10] = d3 - d4;
                    this.buf_1_im[n10] = d2 - d5;
                    d3 = this.buf_2_re[n3];
                    d2 = this.buf_2_im[n3];
                    d4 = this.buf_2_re[n10] * this.w_re[n6][n5] - this.buf_2_im[n10] * this.w_im[n6][n5];
                    d5 = this.buf_2_im[n10] * this.w_re[n6][n5] + this.buf_2_re[n10] * this.w_im[n6][n5];
                    this.buf_2_re[n3] = d3 + d4;
                    this.buf_2_im[n3] = d2 + d5;
                    this.buf_2_re[n10] = d3 - d4;
                    this.buf_2_im[n10] = d2 - d5;
                }
            }
        }
        for (n6 = 0; n6 < 64; ++n6) {
            double d6 = this.buf_1_re[n6];
            d2 = -this.buf_1_im[n6];
            this.buf_1_re[n6] = d6 * this.xcos2[n6] - d2 * this.xsin2[n6];
            this.buf_1_im[n6] = d6 * this.xsin2[n6] + d2 * this.xcos2[n6];
            d6 = this.buf_2_re[n6];
            d2 = -this.buf_2_im[n6];
            this.buf_2_re[n6] = d6 * this.xcos2[n6] - d2 * this.xsin2[n6];
            this.buf_2_im[n6] = d6 * this.xsin2[n6] + d2 * this.xcos2[n6];
        }
        n6 = n;
        n5 = n2;
        n4 = 0;
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n6++] = -this.buf_1_im[n3] * window[n4++] + dArray[n5++] + d;
            dArray[n6++] = this.buf_1_re[64 - n3 - 1] * window[n4++] + dArray[n5++] + d;
        }
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n6++] = -this.buf_1_re[n3] * window[n4++] + dArray[n5++] + d;
            dArray[n6++] = this.buf_1_im[64 - n3 - 1] * window[n4++] + dArray[n5++] + d;
        }
        n5 = n2;
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n5++] = -this.buf_2_re[n3] * window[--n4];
            dArray[n5++] = this.buf_2_im[64 - n3 - 1] * window[--n4];
        }
        for (n3 = 0; n3 < 64; ++n3) {
            dArray[n5++] = this.buf_2_im[n3] * window[--n4];
            dArray[n5++] = -this.buf_2_re[64 - n3 - 1] * window[--n4];
        }
    }

    public SoundOutput() {
        int n;
        for (n = 0; n < 128; ++n) {
            this.xcos1[n] = -Math.cos(0.0015339807878856412 * (double)(8 * n + 1));
            this.xsin1[n] = -Math.sin(0.0015339807878856412 * (double)(8 * n + 1));
        }
        for (n = 0; n < 64; ++n) {
            this.xcos2[n] = -Math.cos(0.0030679615757712823 * (double)(8 * n + 1));
            this.xsin2[n] = -Math.sin(0.0030679615757712823 * (double)(8 * n + 1));
        }
        for (n = 0; n < 7; ++n) {
            int n2 = 1 << n;
            for (int i = 0; i < n2; ++i) {
                this.w_re[n][i] = Math.cos(-Math.PI * (double)i / (double)n2);
                this.w_im[n][i] = Math.sin(-Math.PI * (double)i / (double)n2);
            }
        }
    }

    public void getAudioBuffer(double[] dArray, int n, Buffer buffer) {
        if (n > 2) {
            n = 2;
        }
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getLength();
        if (byArray == null) {
            byArray = new byte[n * 256 * 2 * 1000];
            n2 = 0;
            buffer.setData((Object)byArray);
            buffer.setLength(n2);
        }
        if (byArray.length < n * 256 * 2 + buffer.getLength()) {
            byte[] byArray2 = new byte[(n2 + n * 256 * 2) * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
            buffer.setData((Object)byArray);
        }
        buffer.setLength(n2 + n * 256 * 2);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = (int)(volumeControl * dArray[i + 256 * j + 256]);
                if (n3 > Short.MAX_VALUE) {
                    n3 = 12;
                }
                if (n3 < Short.MIN_VALUE) {
                    n3 = -15;
                }
                byArray[n2++] = (byte)(n3 & 0xFF);
                byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
            }
        }
    }
}

