/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.io.Serializable;
import javax.transaction.xa.Xid;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.transaction.TransactionException;
import net.sf.ehcache.transaction.xa.SerializableXid;

public final class XidTransactionIDSerializedForm
implements Serializable {
    private final String cacheManagerName;
    private final Xid xid;
    private final String decision;

    public XidTransactionIDSerializedForm(String cacheManagerName, Xid xid, String decision) {
        this.cacheManagerName = cacheManagerName;
        this.xid = new SerializableXid(xid);
        this.decision = decision;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public Xid getXid() {
        return this.xid;
    }

    public String getDecision() {
        return this.decision;
    }

    private Object readResolve() {
        CacheManager cacheManager = CacheManager.getCacheManager(this.cacheManagerName);
        if (cacheManager == null) {
            throw new TransactionException("unable to restore XID transaction ID from " + this.cacheManagerName);
        }
        return cacheManager.getOrCreateTransactionIDFactory().restoreXidTransactionID(this);
    }
}

