/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheManager {
    private static final Logger logger = Logger.getLogger(CacheManager.class.toString());
    private int fileCount = 0;
    private Vector cachedFiles = new Vector(128);

    public synchronized void addCachedFile(String string) {
        ++this.fileCount;
        this.cachedFiles.add(string);
    }

    public void dispose() {
        for (Object e : this.cachedFiles) {
            String string = (String)e;
            try {
                boolean bl = new File(string).delete();
                if (bl || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("Error deleting cached file " + string);
            }
            catch (SecurityException securityException) {
                logger.log(Level.FINE, "Security error removing cached file " + string, securityException);
            }
        }
    }
}

