/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;

public class EncryptionDictionary
extends Dictionary {
    private Vector fileID = null;

    public EncryptionDictionary(Library library, Hashtable hashtable, Vector vector) {
        super(library, hashtable);
        this.entries = hashtable;
        this.fileID = vector;
    }

    public Vector getFileID() {
        return this.fileID;
    }

    public String getPerferredSecurityHandlerName() {
        return this.library.getName(this.entries, "Filter");
    }

    public String getPerferredSecurityHandlerSubName() {
        return this.library.getName(this.entries, "SubFilter");
    }

    public int getVersion() {
        return this.library.getInt(this.entries, "V");
    }

    public int getKeyLength() {
        int n = 40;
        int n2 = this.library.getInt(this.entries, "Length");
        if (n2 != 0) {
            n = n2;
        }
        return n;
    }

    public int getRevisionNumber() {
        return this.library.getInt(this.entries, "R");
    }

    public String getBigO() {
        Object object = this.library.getObject(this.entries, "O");
        if (object instanceof StringObject) {
            return ((StringObject)this.library.getObject(this.entries, "O")).getLiteralString();
        }
        return null;
    }

    public String getBigU() {
        Object object = this.library.getObject(this.entries, "U");
        if (object instanceof StringObject) {
            return ((StringObject)this.library.getObject(this.entries, "U")).getLiteralString();
        }
        return null;
    }

    public int getPermissions() {
        return this.library.getInt(this.entries, "P");
    }

    public Object getValue(Object object) {
        return this.entries.get(object);
    }

    public Hashtable getEntries() {
        return this.entries;
    }

    public String toString() {
        return "Encryption Dictionary:  \n  fileID: " + this.getFileID() + " \n" + "  Filter: " + this.getPerferredSecurityHandlerName() + " \n" + "  SubFilter: " + this.getPerferredSecurityHandlerSubName() + " \n" + "  V: " + this.getVersion() + " \n" + "  P: " + this.getPermissions() + " \n" + "  Length:" + this.getKeyLength() + " \n" + "  CF: " + "not done yet" + " \n" + "  StmF: " + "not done yet" + " \n" + "  StrF: " + "not done yet" + " \n" + "  R: " + this.getRevisionNumber() + " \n" + "  O: " + this.getBigO() + " \n" + "  U: " + this.getBigU() + " \n" + "  Recipients: " + "not done yet" + " \n" + "  ";
    }
}

