/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.util.Defs;

public class TextSprite {
    private static final boolean OPTIMIZED_DRAWING_ENABLED = Defs.booleanProperty("org.icepdf.core.text.optimized", true);
    private float[][] textObjects;
    private int count;
    private Color strokeColor;
    private int rmode;
    private FontFile font;
    Rectangle2D.Float bounds;

    public TextSprite(FontFile fontFile, int n) {
        this.textObjects = new float[n][3];
        this.font = fontFile;
        this.bounds = new Rectangle2D.Float();
    }

    public void addText(char c, float f, float f2, float f3) {
        this.textObjects[this.count][0] = f;
        this.textObjects[this.count][1] = f2;
        this.textObjects[this.count][2] = c;
        float f4 = f3;
        float f5 = (float)(this.font.getAscent() + this.font.getDescent());
        if (f5 <= 0.0f) {
            f5 = (float)this.font.getMaxCharBounds().getHeight();
        }
        if (f4 <= 0.0f) {
            f4 = (float)this.font.getMaxCharBounds().getWidth();
        }
        if (f5 <= 0.0f) {
            f5 = 1.0f;
        }
        if (f4 <= 0.0f) {
            f4 = 1.0f;
        }
        this.bounds.add(new Rectangle2D.Float(f, f2 - (float)this.font.getAscent(), f4, f5));
        ++this.count;
    }

    public void setRMode(int n) {
        if (n >= 0) {
            this.rmode = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.textObjects.length);
        int n = this.textObjects.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.textObjects[i][2]);
        }
        return stringBuffer.toString();
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public float[][] getTextObjects() {
        return this.textObjects;
    }

    public int getSize() {
        return this.textObjects.length;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (int i = this.textObjects.length - 1; i >= 0; --i) {
            this.font.drawEstring(graphics2D, String.valueOf((char)this.textObjects[i][2]), this.textObjects[i][0], this.textObjects[i][1], 0L, this.rmode, this.strokeColor);
        }
    }

    public boolean intersects(Shape shape) {
        return !OPTIMIZED_DRAWING_ENABLED || shape.intersects(this.bounds);
    }

    public void dispose() {
        this.textObjects = null;
        this.strokeColor = null;
        this.font = null;
    }
}

