/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.actions.GoToRAction;
import org.icepdf.core.pobjects.actions.LaunchAction;
import org.icepdf.core.pobjects.actions.URIAction;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.Library;

public class Annotation
extends Dictionary {
    protected BorderStyle borderStyle;
    protected Color borderColor;

    public static Annotation buildAnnotation(Library library, Hashtable hashtable) {
        Annotation annotation = null;
        Name name = (Name)hashtable.get("Subtype");
        if (name != null && name.equals("Link")) {
            annotation = new LinkAnnotation(library, hashtable);
        }
        if (annotation == null) {
            annotation = new Annotation(library, hashtable);
        }
        return annotation;
    }

    public Annotation(Library library, Hashtable hashtable) {
        super(library, hashtable);
        Hashtable hashtable2 = (Hashtable)this.getObject("BS");
        if (hashtable2 != null) {
            this.borderStyle = new BorderStyle(this.library, hashtable2);
        }
    }

    public String getSubType() {
        return this.library.getName(this.entries, "Subtype");
    }

    public Rectangle2D.Float getUserSpaceRectangle() {
        return this.library.getRectangle(this.entries, "Rect");
    }

    public Action getAction() {
        String string;
        Hashtable hashtable = this.library.getDictionary(this.entries, "A");
        if (hashtable != null && (string = ((Name)hashtable.get("S")).getName()) != null) {
            if (string.equals("GoTo")) {
                return new GoToAction(this.library, hashtable);
            }
            if (string.equals("GoToR")) {
                return new GoToRAction(this.library, hashtable);
            }
            if (string.equals("Launch")) {
                return new LaunchAction(this.library, hashtable);
            }
            if (string.equals("URI")) {
                return new URIAction(this.library, hashtable);
            }
            return new Action(this.library, hashtable);
        }
        return null;
    }

    public boolean allowScreenNormalMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        return !this.getFlagNoView();
    }

    public boolean allowScreenRolloverMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        if (this.getFlagNoView() && !this.getFlagToggleNoView()) {
            return false;
        }
        return !this.getFlagReadOnly();
    }

    public boolean allowScreenDownMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        if (this.getFlagNoView() && !this.getFlagToggleNoView()) {
            return false;
        }
        return !this.getFlagReadOnly();
    }

    public boolean allowPrintNormalMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        return this.getFlagPrint();
    }

    public boolean allowAlterProperties() {
        return !this.getFlagLocked();
    }

    public void setBorderStyle(BorderStyle borderStyle) {
        this.borderStyle = borderStyle;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public Annotation getParentAnnotation() {
        Annotation annotation = null;
        Object object = this.getObject("Parent");
        if (object instanceof Reference) {
            object = this.library.getObject((Reference)object);
        }
        if (object instanceof Annotation) {
            annotation = (Annotation)object;
        } else if (object instanceof Hashtable) {
            annotation = Annotation.buildAnnotation(this.library, (Hashtable)object);
        }
        return annotation;
    }

    public Page getPage() {
        Annotation annotation;
        Page page = (Page)this.getObject("P");
        if (page == null && (annotation = this.getParentAnnotation()) != null) {
            page = annotation.getPage();
        }
        return page;
    }

    public void render(Graphics2D graphics2D, int n, float f, float f2, boolean bl) {
        boolean bl2;
        double d;
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return;
        }
        if (n == 1 && !this.allowScreenNormalMode()) {
            return;
        }
        if (n == 2 && !this.allowPrintNormalMode()) {
            return;
        }
        Rectangle2D.Float float_ = this.getUserSpaceRectangle();
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Graphics2D graphics2D2 = graphics2D;
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.translate(float_.getMinX(), float_.getMinY());
        boolean bl3 = this.getFlagNoRotate();
        if (bl3) {
            float f3;
            for (f3 = -f; f3 < 0.0f; f3 += 360.0f) {
            }
            while (f3 > 360.0f) {
                f3 -= 360.0f;
            }
            if (f3 == -0.0f) {
                f3 = 0.0f;
            }
            if ((double)f3 != 0.0) {
                d = Math.toRadians(f3);
                AffineTransform affineTransform3 = AffineTransform.getRotateInstance(d);
                Point2D.Double double_ = new Point2D.Double(0.0, Math.abs(float_.getHeight()));
                Point2D point2D = affineTransform3.transform(double_, null);
                affineTransform2.translate(double_.getX() - point2D.getX(), double_.getY() - point2D.getY());
                affineTransform2.rotate(d);
            }
        }
        if ((bl2 = this.getFlagNoZoom()) && (d = Math.abs(affineTransform2.getScaleY())) != 1.0) {
            double d2 = Math.abs(affineTransform2.getScaleX());
            double d3 = Math.abs(float_.getHeight());
            double d4 = d3 * ((d - 1.0) / d);
            affineTransform2.translate(0.0, d4);
            affineTransform2.scale(1.0 / d2, 1.0 / d);
        }
        graphics2D2.setTransform(affineTransform2);
        Shape shape2 = graphics2D2.getClip();
        graphics2D2.clip(this.deriveDrawingRectangle());
        this.renderAppearanceStream(graphics2D2);
        graphics2D2.setTransform(affineTransform2);
        graphics2D2.setClip(shape2);
        if (bl) {
            this.renderBorderTabSelected(graphics2D2);
        } else {
            this.renderBorder(graphics2D2);
        }
        graphics2D2.setTransform(affineTransform);
        graphics2D2.setClip(shape);
    }

    protected void renderAppearanceStream(Graphics2D graphics2D) {
        Object object = this.getObject("AP");
        if (object instanceof Hashtable) {
            Object object2;
            Object object3 = this.library.getObject((Hashtable)object, "N");
            if (object3 instanceof Hashtable && (object2 = this.getObject("AS")) != null) {
                object3 = this.library.getObject((Hashtable)object3, object2.toString());
            }
            if (object3 instanceof Form) {
                object2 = (Form)object3;
                ((Form)object2).init();
                AffineTransform affineTransform = ((Form)object2).getMatrix();
                if (affineTransform != null) {
                    graphics2D.transform(affineTransform);
                }
                Shapes shapes = ((Form)object2).getShapes();
                shapes.paint(graphics2D);
            }
        }
    }

    protected void renderBorder(Graphics2D graphics2D) {
        BorderStyle borderStyle;
        Color color = this.getBorderColor();
        if (color != null) {
            graphics2D.setColor(color);
        }
        if ((borderStyle = this.getBorderStyle()) != null) {
            float f = borderStyle.getStrokeWidth();
            if (f > 0.0f) {
                Rectangle2D.Float float_ = this.deriveBorderDrawingRectangle(f);
                if (borderStyle.isStyleSolid()) {
                    if (color != null) {
                        graphics2D.setStroke(new BasicStroke(f));
                        graphics2D.draw(float_);
                    }
                } else if (borderStyle.isStyleDashed()) {
                    if (color != null) {
                        BasicStroke basicStroke = new BasicStroke(f, 0, 0, 10.0f, borderStyle.getDashArray(), 0.0f);
                        graphics2D.setStroke(basicStroke);
                        graphics2D.draw(float_);
                    }
                } else if (borderStyle.isStyleBeveled()) {
                    if (color != null) {
                        float_ = this.deriveDrawingRectangle();
                        graphics2D.setStroke(new BasicStroke(1.0f));
                        graphics2D.setColor(BorderStyle.LIGHT);
                        Line2D.Double double_ = new Line2D.Double(float_.getMinX() + 1.0, float_.getMaxY() - 1.0, float_.getMaxX() - 2.0, float_.getMaxY() - 1.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMinX() + 1.0, float_.getMinY() + 2.0, float_.getMinX() + 1.0, float_.getMaxY() - 1.0);
                        graphics2D.draw(double_);
                        graphics2D.setColor(BorderStyle.LIGHTEST);
                        double_ = new Line2D.Double(float_.getMinX() + 2.0, float_.getMaxY() - 2.0, float_.getMaxX() - 3.0, float_.getMaxY() - 2.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMinX() + 2.0, float_.getMinY() + 3.0, float_.getMinX() + 2.0, float_.getMaxY() - 2.0);
                        graphics2D.draw(double_);
                        graphics2D.setColor(BorderStyle.DARK);
                        double_ = new Line2D.Double(float_.getMinX() + 2.0, float_.getMinY() + 2.0, float_.getMaxX() - 2.0, float_.getMinY() + 2.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMaxX() - 2.0, float_.getMinY() + 2.0, float_.getMaxX() - 2.0, float_.getMaxY() - 2.0);
                        graphics2D.draw(double_);
                        graphics2D.setColor(BorderStyle.DARKEST);
                        double_ = new Line2D.Double(float_.getMinX() + 1.0, float_.getMinY() + 1.0, float_.getMaxX() - 1.0, float_.getMinY() + 1.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMaxX() - 1.0, float_.getMinY() + 1.0, float_.getMaxX() - 1.0, float_.getMaxY() - 1.0);
                        graphics2D.draw(double_);
                    }
                } else if (borderStyle.isStyleInset()) {
                    if (color != null) {
                        float_ = this.deriveDrawingRectangle();
                        graphics2D.setStroke(new BasicStroke(1.0f));
                        graphics2D.setColor(BorderStyle.DARK);
                        Line2D.Double double_ = new Line2D.Double(float_.getMinX() + 1.0, float_.getMaxY() - 1.0, float_.getMaxX() - 1.0, float_.getMaxY() - 1.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMinX() + 1.0, float_.getMinY() + 1.0, float_.getMinX() + 1.0, float_.getMaxY() - 1.0);
                        graphics2D.draw(double_);
                        graphics2D.setColor(BorderStyle.DARKEST);
                        double_ = new Line2D.Double(float_.getMinX() + 2.0, float_.getMaxY() - 2.0, float_.getMaxX() - 2.0, float_.getMaxY() - 2.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMinX() + 2.0, float_.getMinY() + 2.0, float_.getMinX() + 2.0, float_.getMaxY() - 2.0);
                        graphics2D.draw(double_);
                        graphics2D.setColor(BorderStyle.LIGHTEST);
                        double_ = new Line2D.Double(float_.getMinX() + 3.0, float_.getMinY() + 2.0, float_.getMaxX() - 2.0, float_.getMinY() + 2.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMaxX() - 2.0, float_.getMinY() + 2.0, float_.getMaxX() - 2.0, float_.getMaxY() - 3.0);
                        graphics2D.draw(double_);
                        graphics2D.setColor(BorderStyle.LIGHT);
                        double_ = new Line2D.Double(float_.getMinX() + 2.0, float_.getMinY() + 1.0, float_.getMaxX() - 1.0, float_.getMinY() + 1.0);
                        graphics2D.draw(double_);
                        double_ = new Line2D.Double(float_.getMaxX() - 1.0, float_.getMinY() + 1.0, float_.getMaxX() - 1.0, float_.getMaxY() - 2.0);
                        graphics2D.draw(double_);
                    }
                } else if (borderStyle.isStyleUnderline() && color != null) {
                    graphics2D.setStroke(new BasicStroke(f));
                    Line2D.Double double_ = new Line2D.Double(float_.getMinX(), float_.getMinY(), float_.getMaxX(), float_.getMinY());
                    graphics2D.draw(double_);
                }
            }
        } else {
            Vector vector = (Vector)this.getObject("Border");
            if (vector != null) {
                if (color != null) {
                    Cloneable cloneable;
                    Object object;
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 1.0f;
                    float[] fArray = null;
                    if (vector.size() >= 1) {
                        f = ((Number)vector.get(0)).floatValue();
                    }
                    if (vector.size() >= 2) {
                        f2 = ((Number)vector.get(1)).floatValue();
                    }
                    if (vector.size() >= 3) {
                        f3 = ((Number)vector.get(2)).floatValue();
                    }
                    if (vector.size() >= 4) {
                        object = vector.get(3);
                        if (object instanceof Number) {
                            f3 = 0.0f;
                        } else if (object instanceof Vector) {
                            cloneable = (Vector)vector.get(3);
                            int n = ((Vector)cloneable).size();
                            fArray = new float[n];
                            for (int i = 0; i < n; ++i) {
                                Number number = (Number)((Vector)cloneable).get(i);
                                fArray[i] = number.floatValue();
                            }
                        }
                    }
                    if (f3 > 0.0f) {
                        object = this.deriveBorderDrawingRectangle(f3);
                        cloneable = new RoundRectangle2D.Double(((Rectangle2D.Float)object).getX(), ((Rectangle2D.Float)object).getY(), ((Rectangle2D.Float)object).getWidth(), ((Rectangle2D.Float)object).getHeight(), f, f2);
                        BasicStroke basicStroke = new BasicStroke(f3, 0, 0, 10.0f, fArray, 0.0f);
                        graphics2D.setStroke(basicStroke);
                        graphics2D.draw((Shape)((Object)cloneable));
                    }
                }
            } else if (color != null) {
                float f = 1.0f;
                Rectangle2D.Float float_ = this.deriveBorderDrawingRectangle(f);
                graphics2D.setStroke(new BasicStroke(f));
                graphics2D.draw(float_);
            }
        }
    }

    protected void renderBorderTabSelected(Graphics2D graphics2D) {
        float f = 1.0f;
        Rectangle2D.Float float_ = this.deriveBorderDrawingRectangle(f);
        graphics2D.setColor(Color.black);
        float[] fArray = new float[]{2.0f};
        BasicStroke basicStroke = new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(float_);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    private PRectangle getRectangle() {
        Vector vector = (Vector)this.getObject("Rect");
        PRectangle pRectangle = new PRectangle(vector);
        return pRectangle;
    }

    private Rectangle2D.Float deriveDrawingRectangle() {
        Rectangle2D.Float float_ = this.getUserSpaceRectangle();
        float_.x = 0.0f;
        float_.y = 0.0f;
        return float_;
    }

    private Rectangle2D.Float deriveBorderDrawingRectangle(float f) {
        Rectangle2D.Float float_ = this.deriveDrawingRectangle();
        float f2 = f / 2.0f;
        double d = float_.getMinX() + (double)f2;
        double d2 = float_.getMinY() + (double)f2;
        double d3 = float_.getMaxX() - (double)f2;
        double d4 = float_.getMaxY() - (double)f2;
        float_.setFrameFromDiagonal(d, d2, d3, d4);
        return float_;
    }

    protected boolean allowScreenOrPrintRenderingOrInteraction() {
        if (this.getFlagHidden()) {
            return false;
        }
        return !this.getFlagInvisible() || !this.isSupportedAnnotationType();
    }

    protected boolean isSupportedAnnotationType() {
        return true;
    }

    private boolean getFlagInvisible() {
        return (this.getInt("F") & 1) != 0;
    }

    private boolean getFlagHidden() {
        return (this.getInt("F") & 2) != 0;
    }

    private boolean getFlagPrint() {
        return (this.getInt("F") & 4) != 0;
    }

    private boolean getFlagNoZoom() {
        return (this.getInt("F") & 8) != 0;
    }

    private boolean getFlagNoRotate() {
        return (this.getInt("F") & 0x10) != 0;
    }

    private boolean getFlagNoView() {
        return (this.getInt("F") & 0x20) != 0;
    }

    private boolean getFlagReadOnly() {
        return (this.getInt("F") & 0x40) != 0;
    }

    private boolean getFlagLocked() {
        return (this.getInt("F") & 0x80) != 0;
    }

    private boolean getFlagToggleNoView() {
        return (this.getInt("F") & 0x100) != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANNOTATION= {");
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.entries.get(k);
            stringBuffer.append(k.toString());
            stringBuffer.append('=');
            if (v == null) {
                stringBuffer.append("null");
            } else if (v instanceof StringObject) {
                stringBuffer.append(((StringObject)v).getDecryptedLiteralString(this.library.securityManager));
            } else {
                stringBuffer.append(v.toString());
            }
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        if (this.getPObjectReference() != null) {
            stringBuffer.append("  ");
            stringBuffer.append(this.getPObjectReference());
        }
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) >= ' ' && stringBuffer.charAt(i) < '\u007f') continue;
            stringBuffer.deleteCharAt(i);
        }
        return stringBuffer.toString();
    }
}

