/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.util.Library;

public class PageTree
extends Dictionary {
    private int kidsCount = 0;
    private Vector kidsReferences;
    private Vector kidsPageAndPages;
    private PageTree parent;
    private boolean inited;
    private PRectangle mediaBox;
    private PRectangle cropBox;
    private Resources resources;
    protected float rotationFactor = 0.0f;
    protected boolean isRotationFactor = false;

    public PageTree(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    protected synchronized void dispose(boolean bl) {
        if (this.kidsReferences != null && !bl) {
            this.kidsReferences.clear();
        }
        if (this.kidsPageAndPages != null) {
            for (Object e : this.kidsPageAndPages) {
                if (e instanceof Page) {
                    ((Page)e).dispose(bl);
                    continue;
                }
                if (!(e instanceof PageTree)) continue;
                ((PageTree)e).dispose(bl);
            }
            if (!bl) {
                this.kidsPageAndPages.clear();
            }
        }
        if (this.resources != null) {
            this.resources.dispose(bl);
        }
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Object object = this.library.getObject(this.entries, "Parent");
        if (object instanceof PageTree) {
            this.parent = (PageTree)this.library.getObject(this.entries, "Parent");
        }
        this.kidsCount = this.library.getNumber(this.entries, "Count").intValue();
        Vector vector = (Vector)this.library.getObject(this.entries, "MediaBox");
        if (vector != null) {
            this.mediaBox = new PRectangle(vector);
        }
        if ((vector = (Vector)this.library.getObject(this.entries, "CropBox")) != null) {
            this.cropBox = new PRectangle(vector);
        }
        this.resources = this.library.getResources(this.entries, "Resources");
        this.kidsReferences = (Vector)this.library.getObject(this.entries, "Kids");
        this.kidsPageAndPages = new Vector(this.kidsReferences.size());
        this.kidsPageAndPages.setSize(this.kidsReferences.size());
        Object object2 = this.library.getObject(this.entries, "Rotate");
        if (object2 != null) {
            this.rotationFactor = ((Number)object2).floatValue();
            this.isRotationFactor = true;
        }
        this.inited = true;
    }

    void initRootPageTree() {
    }

    public PRectangle getMediaBox() {
        return this.mediaBox;
    }

    public PRectangle getCropBox() {
        return this.cropBox;
    }

    public Resources getResources() {
        return this.resources;
    }

    public PageTree getParent() {
        return this.parent;
    }

    public int getPageNumber(Reference reference) {
        Page page = (Page)this.library.getObject(reference);
        if (page == null) {
            return -1;
        }
        int n = 0;
        Reference reference2 = reference;
        Reference reference3 = page.getParentReference();
        PageTree pageTree = page.getParent();
        while (reference3 != null && pageTree != null) {
            pageTree.init();
            int n2 = pageTree.indexOfKidReference(reference2);
            if (n2 < 0) {
                return -1;
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Object object = pageTree.getPageOrPagesPotentiallyNotInitedFromReferenceAt(i);
                if (object instanceof Page) {
                    ++n3;
                    continue;
                }
                if (!(object instanceof PageTree)) continue;
                PageTree pageTree2 = (PageTree)object;
                pageTree2.init();
                n3 += pageTree2.getNumberOfPages();
            }
            n += n3;
            reference2 = reference3;
            reference3 = (Reference)pageTree.entries.get("Parent");
            pageTree = pageTree.parent;
        }
        return n;
    }

    private int indexOfKidReference(Reference reference) {
        for (int i = 0; i < this.kidsReferences.size(); ++i) {
            Reference reference2 = (Reference)this.kidsReferences.get(i);
            if (!reference2.equals(reference)) continue;
            return i;
        }
        return -1;
    }

    private Object getPageOrPagesPotentiallyNotInitedFromReferenceAt(int n) {
        Object object = this.kidsPageAndPages.get(n);
        if (object == null) {
            Reference reference = (Reference)this.kidsReferences.get(n);
            object = this.library.getObject(reference);
            this.kidsPageAndPages.set(n, object);
        }
        return object;
    }

    private Page getPagePotentiallyNotInitedByRecursiveIndex(int n) {
        int n2 = 0;
        int n3 = this.kidsPageAndPages.size();
        for (int i = 0; i < n3; ++i) {
            Object object = this.getPageOrPagesPotentiallyNotInitedFromReferenceAt(i);
            if (object instanceof Page) {
                if (n == n2) {
                    return (Page)object;
                }
                ++n2;
                continue;
            }
            if (!(object instanceof PageTree)) continue;
            PageTree pageTree = (PageTree)object;
            pageTree.init();
            int n4 = pageTree.getNumberOfPages();
            if (n >= n2 && n < n2 + n4) {
                return pageTree.getPagePotentiallyNotInitedByRecursiveIndex(n - n2);
            }
            n2 += n4;
        }
        return null;
    }

    public int getNumberOfPages() {
        return this.kidsCount;
    }

    public Page getPage(int n, Object object) {
        if (n < 0) {
            return null;
        }
        Page page = this.getPagePotentiallyNotInitedByRecursiveIndex(n);
        if (page != null) {
            this.library.memoryManager.lock(object, page);
        }
        return page;
    }

    public void releasePage(Page page, Object object) {
        if (this.library != null && this.library.memoryManager != null) {
            this.library.memoryManager.release(object, page);
        }
    }

    public void releasePage(int n, Object object) {
        Page page = this.getPagePotentiallyNotInitedByRecursiveIndex(n);
        this.library.memoryManager.release(object, page);
    }

    public String toString() {
        return "PAGES= " + this.entries.toString();
    }
}

