/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.icepdf.core.io.SeekableInput;

public class SeekableInputConstrainedWrapper
extends InputStream {
    private SeekableInput streamDataInput;
    private long filePositionOfStreamData;
    private long lengthOfStreamData;
    private long filePositionBeforeUse;
    private boolean takeOwnershipOfStreamDataInput;
    private boolean usedYet;

    public SeekableInputConstrainedWrapper(SeekableInput seekableInput, long l, long l2, boolean bl) {
        this.streamDataInput = seekableInput;
        this.filePositionOfStreamData = l;
        this.lengthOfStreamData = l2;
        this.filePositionBeforeUse = 0L;
        this.takeOwnershipOfStreamDataInput = bl;
        this.usedYet = false;
    }

    public void prepareForCurrentUse() {
        this.usedYet = false;
    }

    public void dispose() throws IOException {
        this.beginThreadAccess();
        if (this.takeOwnershipOfStreamDataInput) {
            if (this.streamDataInput != null) {
                this.streamDataInput.close();
                this.endThreadAccess();
                this.streamDataInput = null;
            }
        } else {
            this.endCurrentUse();
        }
    }

    private void ensureReadyOnFirstUse() throws IOException {
        this.beginThreadAccess();
        if (this.usedYet) {
            return;
        }
        this.usedYet = true;
        this.filePositionBeforeUse = this.streamDataInput.getAbsolutePosition();
        this.streamDataInput.seekAbsolute(this.filePositionOfStreamData);
    }

    private void endCurrentUse() throws IOException {
        if (this.usedYet) {
            this.streamDataInput.seekAbsolute(this.filePositionBeforeUse);
            this.usedYet = false;
        }
        this.endThreadAccess();
    }

    private long getBytesRemaining() throws IOException {
        long l = this.streamDataInput.getAbsolutePosition();
        if (l < this.filePositionOfStreamData) {
            return -1L;
        }
        long l2 = this.filePositionOfStreamData + this.lengthOfStreamData;
        return l2 - l;
    }

    public int read() throws IOException {
        this.ensureReadyOnFirstUse();
        long l = this.getBytesRemaining();
        if (l <= 0L) {
            return -1;
        }
        return this.streamDataInput.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureReadyOnFirstUse();
        long l = this.getBytesRemaining();
        if (l <= 0L) {
            return -1;
        }
        n2 = (int)Math.min(Math.min(l, (long)n2), Integer.MAX_VALUE);
        return this.streamDataInput.read(byArray, n, n2);
    }

    public void close() throws IOException {
        this.beginThreadAccess();
        this.endCurrentUse();
    }

    public int available() {
        return 0;
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
    }

    public long skip(long l) throws IOException {
        this.ensureReadyOnFirstUse();
        long l2 = this.getBytesRemaining();
        if (l2 <= 0L) {
            return -1L;
        }
        l = (int)Math.min(Math.min(l2, l), Integer.MAX_VALUE);
        return this.streamDataInput.skip(l);
    }

    public void seekAbsolute(long l) throws IOException {
        this.ensureReadyOnFirstUse();
        if (l < 0L) {
            throw new IOException("Attempt to absolutely seek to negative location: " + l);
        }
        this.streamDataInput.seekAbsolute(l += this.filePositionOfStreamData);
    }

    public void seekRelative(long l) throws IOException {
        this.ensureReadyOnFirstUse();
        long l2 = this.streamDataInput.getAbsolutePosition();
        if ((l2 += l) < this.filePositionOfStreamData) {
            l2 = this.filePositionOfStreamData;
        }
        this.streamDataInput.seekAbsolute(l2);
    }

    public void seekEnd() throws IOException {
        this.ensureReadyOnFirstUse();
        this.streamDataInput.seekAbsolute(this.filePositionOfStreamData + this.lengthOfStreamData);
    }

    public long getAbsolutePosition() throws IOException {
        this.ensureReadyOnFirstUse();
        long l = this.getAbsolutePosition();
        return l -= this.filePositionOfStreamData;
    }

    public long getLength() {
        return this.lengthOfStreamData;
    }

    public InputStream getInputStream() {
        return this;
    }

    public void beginThreadAccess() {
        if (this.streamDataInput != null) {
            this.streamDataInput.beginThreadAccess();
        }
    }

    public void endThreadAccess() {
        if (this.streamDataInput != null) {
            this.streamDataInput.endThreadAccess();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" ( ");
        stringBuffer.append("pos=").append(this.filePositionOfStreamData).append(", ");
        stringBuffer.append("len=").append(this.lengthOfStreamData).append(", ");
        stringBuffer.append("posToRestore=").append(this.filePositionBeforeUse).append(", ");
        stringBuffer.append("own=").append(this.takeOwnershipOfStreamDataInput).append(", ");
        stringBuffer.append("usedYet=").append(this.usedYet);
        stringBuffer.append(" ) ");
        stringBuffer.append(": ");
        if (this.streamDataInput == null) {
            stringBuffer.append("null ");
        } else {
            stringBuffer.append(this.streamDataInput.toString());
        }
        return stringBuffer.toString();
    }
}

