/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.remoting;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PagedRowSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.RowSet;

public class PageableRowSetCache {
    private static final int DEFAULT_PAGE_SIZE = 25;

    public static PageableRowSet cacheRowSet(RowSet rowset, int pageSize) {
        if (pageSize <= 0) {
            pageSize = 25;
        }
        PagedRowSet prs = new PagedRowSet(rowset, pageSize, true);
        PageableRowSetCache.cachePageableRowSet((PageableRowSet)prs);
        return prs;
    }

    public static void cachePageableRowSet(PageableRowSet rowset) {
        if (rowset != null) {
            FlexSession session = FlexContext.getFlexSession();
            session.setAttribute(rowset.getID(), (Object)rowset);
        }
    }

    public Map getRecords(String id, int startIndex, int count) throws SQLException {
        Object o;
        Map page = null;
        FlexSession session = FlexContext.getFlexSession();
        if (session != null && (o = session.getAttribute(id)) != null && o instanceof PageableRowSet) {
            PageableRowSet rs = (PageableRowSet)o;
            page = rs.getRecords(startIndex, count);
        }
        return page;
    }

    public void release(String id) {
        FlexSession session = FlexContext.getFlexSession();
        if (session != null) {
            session.removeAttribute(id);
        }
    }
}

