/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;

public class ComplexFileTable {
    private static final byte GRPPRL_TYPE = 1;
    private static final byte TEXT_PIECE_TABLE_TYPE = 2;
    TextPieceTable _tpt;

    public ComplexFileTable(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        int n3;
        while (byArray2[n] == 1) {
            n3 = LittleEndian.getShort(byArray2, ++n);
            n += 2 + n3;
        }
        if (byArray2[n] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        n3 = LittleEndian.getInt(byArray2, ++n);
        this._tpt = new TextPieceTable(byArray, byArray2, n += 4, n3, n2);
    }

    public TextPieceTable getTextPieceTable() {
        return this._tpt;
    }

    public void writeTo(HWPFFileSystem hWPFFileSystem) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream("1Table");
        hWPFOutputStream2.write(2);
        byte[] byArray = this._tpt.writeTo(hWPFOutputStream);
        byte[] byArray2 = new byte[4];
        LittleEndian.putInt(byArray2, byArray.length);
        hWPFOutputStream2.write(byArray2);
        hWPFOutputStream2.write(byArray);
    }
}

