/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.bundle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageCache {
    private Map<String, Image> imageHash = new HashMap<String, Image>(10);
    private URL baseURL;
    private Image missing = null;

    public ImageCache(URL baseURL) {
        this.baseURL = baseURL;
    }

    protected ImageCache() {
    }

    public void dispose() {
        Iterator<Image> e = this.imageHash.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        if (this.missing != null) {
            this.missing.dispose();
        }
    }

    public Image get(String key) {
        Image image = this.imageHash.get(key);
        if (image == null) {
            try {
                ImageDescriptor desc = this.getDescriptor(key);
                image = desc.createImage();
                this.imageHash.put(key, image);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("ERROR: Missing image: " + key);
                if (this.missing == null) {
                    ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
                    this.missing = desc.createImage();
                }
                image = this.missing;
            }
        }
        return image;
    }

    public ImageDescriptor getDescriptor(String key) throws MalformedURLException {
        URL url = new URL(this.baseURL, key);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

