/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.controls.preview;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.refactoring.ui.controls.preview.PyPreviewConfiguration;
import org.python.pydev.ui.ColorCache;

public class PyPreviewProjection
extends ProjectionViewer {
    private ColorCache colorCache;
    private PyPreviewConfiguration editConfiguration;
    private boolean isInToggleCompletionStyle;

    public PyPreviewProjection(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        this.colorCache = new ColorCache(PydevPrefs.getChainedPrefStore());
        this.editConfiguration = new PyPreviewConfiguration(this.colorCache);
        this.configure(this.editConfiguration);
        this.getTextWidget().setEditable(false);
    }

    public void setInToggleCompletionStyle(boolean b) {
        this.isInToggleCompletionStyle = b;
    }

    public boolean getIsInToggleCompletionStyle() {
        return this.isInToggleCompletionStyle;
    }

    public void doOperation(int operation) {
        super.doOperation(operation);
        if (this.getTextWidget() == null) {
            return;
        }
    }

    public void revealUserSelection(ITextSelection selection) {
        this.setBackgroundColor(selection, 16);
    }

    public void revealExtendedSelection(ITextSelection selection) {
        this.setBackgroundColor(selection, 15);
        this.getTextWidget().setSelection(selection.getOffset());
    }

    private void setBackgroundColor(ITextSelection selection, int color) {
        this.setBackgroundColor(selection, Display.getCurrent().getSystemColor(color));
    }

    public void setBackgroundColor(ITextSelection selection, Color color) {
        StyleRange styleRangeNode = new StyleRange(selection.getOffset(), selection.getLength(), null, color);
        this.getTextWidget().setStyleRange(styleRangeNode);
    }
}

