/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.refactoring.ast.rewriter.RewriterVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeHelper {
    private String endLineDelimiter;
    private static final String KEYWORD_FDEL = "fdel";
    private static final String KEYWORD_FSET = "fset";
    private static final String KEYWORD_FGET = "fget";
    private static final String EMPTY = "";
    public static final String KEYWORD_INIT = "__init__";
    private static final String KEYWORD_NONE = "None";
    private static final String KEYWORD_PROPERTY = "property";
    public static final String KEYWORD_SELF = "self";
    private static final String PREFIX_PRIVATE = "__";
    public static final int ACCESS_PUBLIC = 1;
    public static final int ACCESS_PSEUDO = 2;
    public static final int ACCESS_PRIVATE = 3;

    public NodeHelper(String endLineDelimiter) {
        this.endLineDelimiter = endLineDelimiter;
    }

    public String getAccessName(String name, int modifier) {
        switch (modifier) {
            case 2: {
                return this.getPseudoAttr(name);
            }
            case 3: {
                return this.getPrivateAttr(name);
            }
        }
        return this.getPublicAttr(name);
    }

    private String getFromName(SimpleNode node) {
        if (!this.isName(node)) {
            return EMPTY;
        }
        return ((Name)node).id;
    }

    private String getFromNameTok(SimpleNode node) {
        if (node == null) {
            return EMPTY;
        }
        if (!this.isNameTok(node)) {
            return EMPTY;
        }
        return ((NameTok)node).id;
    }

    private String getFromStr(SimpleNode node) {
        if (!this.isStr(node)) {
            return EMPTY;
        }
        return ((Str)node).s;
    }

    public int getLineDefinition(SimpleNode node) {
        while (this.isAttribute(node)) {
            exprType expr = ((Attribute)node).value;
            if (this.isCall((SimpleNode)expr)) break;
            node = expr;
        }
        if (this.isFunctionDef(node)) {
            return ((FunctionDef)node).name.beginLine;
        }
        return node.beginLine;
    }

    public int getLineEnd(SimpleNode node) {
        if (node == null) {
            return 0;
        }
        if (this.isStr(node)) {
            String s = ((Str)node).s;
            int found = 0;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == '\n') {
                    ++found;
                }
                ++i;
            }
            return this.getLineDefinition(node) + found;
        }
        return this.getLineDefinition(node);
    }

    public String getName(SimpleNode node) {
        if (this.isNameTok(node)) {
            return this.getFromNameTok(node);
        }
        if (this.isName(node)) {
            return this.getFromName(node);
        }
        if (this.isStr(node)) {
            return this.getFromStr(node);
        }
        if (this.isClassDef(node)) {
            return this.getName((SimpleNode)((ClassDef)node).name);
        }
        if (this.isFunctionDef(node)) {
            return this.getName((SimpleNode)((FunctionDef)node).name);
        }
        if (this.isCall(node)) {
            return this.getName((SimpleNode)((Call)node).func);
        }
        if (this.isAttribute(node)) {
            String attributeName = RewriterVisitor.createSourceFromAST(node, true, this.endLineDelimiter);
            int subscriptOffset = attributeName.indexOf("[");
            if (subscriptOffset > 0) {
                attributeName = attributeName.substring(0, subscriptOffset - 1);
            }
            return attributeName.trim();
        }
        return EMPTY;
    }

    public String getPrivateAttr(String attributeName) {
        String privateAttr = this.getPublicAttr(attributeName);
        return new StringBuffer(PREFIX_PRIVATE).append(privateAttr).toString();
    }

    private int getPropertyMethods(exprType[] args) {
        if (args == null || args.length == 0) {
            return 0;
        }
        int propertyMethods = args.length;
        exprType lastExpr = args[args.length - 1];
        if (this.isStr((SimpleNode)lastExpr)) {
            --propertyMethods;
        }
        return propertyMethods;
    }

    public String getPseudoAttr(String attributeName) {
        String pseudoAttr = this.getPublicAttr(attributeName);
        return new StringBuffer("_").append(pseudoAttr).toString();
    }

    public String getPublicAttr(String attributeName) {
        String publicAttr = attributeName;
        while (publicAttr.startsWith("_")) {
            publicAttr = publicAttr.substring(1);
        }
        return publicAttr;
    }

    public int getStartLine(SimpleNode n) {
        return n.beginLine;
    }

    public int getStartOffset(SimpleNode n) {
        return n.beginColumn;
    }

    public boolean hasFunctionArgument(SimpleNode node) {
        return this.isFunctionDef(node) || this.isLambda(node);
    }

    public boolean isAssign(SimpleNode node) {
        return node instanceof Assign;
    }

    public boolean isAttribute(SimpleNode node) {
        return node instanceof Attribute;
    }

    public boolean isBoolOp(SimpleNode node) {
        return node instanceof BoolOp;
    }

    public boolean isCall(SimpleNode node) {
        return node instanceof Call;
    }

    public boolean isClassDef(SimpleNode node) {
        return node instanceof ClassDef;
    }

    public boolean isComprehension(SimpleNode node) {
        return node instanceof Comprehension;
    }

    public boolean isConstant(String id) {
        return id.toUpperCase().compareTo(id) == 0;
    }

    public boolean isContextNameParentName(String contextName, SimpleNode node) {
        return contextName.compareTo(this.getName(node)) == 0;
    }

    public boolean isControlStatement(SimpleNode node) {
        return this.isForStatement(node) || this.isWhileStatement(node) || this.isWithStatement(node) || this.isTryExceptStatement(node) || this.isTryFinallyStatement(node) || this.isIfStatement(node);
    }

    public boolean isDict(SimpleNode node) {
        return node instanceof Dict;
    }

    public boolean isEmptyList(SimpleNode[] list) {
        return list == null || list.length == 0;
    }

    public boolean isFDel(keywordType kw) {
        return this.isKeywordName(kw, KEYWORD_FDEL) && !this.isNone((SimpleNode)kw.value);
    }

    public boolean isFGet(keywordType kw) {
        return this.isKeywordName(kw, KEYWORD_FGET) && !this.isNone((SimpleNode)kw.value);
    }

    public boolean isFilledList(SimpleNode[] list) {
        return !this.isEmptyList(list);
    }

    public boolean isForStatement(SimpleNode node) {
        return node instanceof For;
    }

    public boolean isFSet(keywordType kw) {
        return this.isKeywordName(kw, KEYWORD_FSET) && !this.isNone((SimpleNode)kw.value);
    }

    public boolean isFullyQualified(SimpleNode contextNode, SimpleNode parent) {
        return this.isContextNameParentName(this.getName(contextNode), parent) || this.isSelf(this.getName(contextNode));
    }

    public boolean isFunctionArgument(SimpleNode node) {
        return node instanceof argumentsType;
    }

    public boolean isFunctionDef(SimpleNode node) {
        return node instanceof FunctionDef;
    }

    public boolean isFunctionOrClassDef(SimpleNode node) {
        return this.isClassDef(node) || this.isFunctionDef(node);
    }

    public boolean isIfStatement(SimpleNode node) {
        return node instanceof If;
    }

    public boolean isInit(SimpleNode node) {
        return this.isFunctionDef(node) && this.getName(node).compareTo(KEYWORD_INIT) == 0;
    }

    public boolean isKeyword(SimpleNode node) {
        return node instanceof keywordType;
    }

    private boolean isKeywordName(keywordType kw, String name) {
        return this.getName((SimpleNode)kw.arg).compareTo(name) == 0 && this.isName((SimpleNode)kw.value);
    }

    public boolean isKeywordStr(keywordType kw) {
        return this.getName((SimpleNode)kw.arg).compareTo("doc") == 0 && this.isStr((SimpleNode)kw.value);
    }

    public boolean isLambda(SimpleNode node) {
        return node instanceof Lambda;
    }

    public boolean isList(SimpleNode node) {
        return node instanceof org.python.pydev.parser.jython.ast.List;
    }

    public boolean isName(SimpleNode node) {
        return node instanceof Name;
    }

    public boolean isNameTok(SimpleNode node) {
        return node instanceof NameTok;
    }

    public boolean isNone(SimpleNode node) {
        return this.isName(node) && KEYWORD_NONE.compareTo(this.getName(node)) == 0;
    }

    public boolean isPrivate(SimpleNode node) {
        return this.isPrivate(this.getName(node));
    }

    public boolean isPrivate(String name) {
        return name.startsWith(PREFIX_PRIVATE);
    }

    public boolean isProperty(Call node) {
        return this.getName((SimpleNode)node).compareTo(KEYWORD_PROPERTY) == 0 && this.isValidPropertyCall(node);
    }

    public boolean isPropertyAssign(Assign node) throws Exception {
        if (this.isFilledList((SimpleNode[])node.targets) && node.targets.length == 1 && this.isName((SimpleNode)node.targets[0]) && this.isCall((SimpleNode)node.value)) {
            return this.isProperty((Call)node.value);
        }
        return false;
    }

    public boolean isPropertyDecorator(decoratorsType dec) {
        return this.getName((SimpleNode)dec.func).compareTo(KEYWORD_PROPERTY) == 0;
    }

    private boolean isPropertyVar(keywordType kw) {
        return this.isFGet(kw) || this.isFSet(kw) || this.isFDel(kw);
    }

    public boolean isSelf(String id) {
        return KEYWORD_SELF.compareTo(id) == 0;
    }

    public boolean isSpecialStr(Object o) {
        return o instanceof SpecialStr;
    }

    public boolean isStr(SimpleNode node) {
        return node instanceof Str;
    }

    public boolean isTryExceptStatement(SimpleNode node) {
        return node instanceof TryExcept;
    }

    public boolean isTryFinallyStatement(SimpleNode node) {
        return node instanceof TryFinally;
    }

    public boolean isTryStatement(SimpleNode node) {
        return this.isTryExceptStatement(node) || this.isTryFinallyStatement(node);
    }

    public boolean isTuple(SimpleNode node) {
        return node instanceof Tuple;
    }

    private boolean isValidPropertyCall(Call node) {
        exprType[] args = node.args;
        keywordType[] kws = node.keywords;
        int len = args.length + kws.length;
        if (len > 4) {
            return false;
        }
        return this.validatePropertyArguments(node);
    }

    private boolean isValidPropertyKeyword(keywordType[] keywords) {
        if (keywords != null) {
            boolean valid = false;
            keywordType[] keywordTypeArray = keywords;
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                keywordType kw = keywordTypeArray[n2];
                boolean bl = valid = this.isKeywordStr(kw) || this.isPropertyVar(kw);
                if (!valid) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean isWhileStatement(SimpleNode node) {
        return node instanceof While;
    }

    public boolean isWithStatement(SimpleNode node) {
        return node instanceof With;
    }

    public boolean isImport(SimpleNode node) {
        return node instanceof ImportFrom || node instanceof Import;
    }

    private boolean validatePropertyArguments(Call node) {
        exprType[] args = node.args;
        if (this.isValidPropertyKeyword(node.keywords)) {
            int propertyMethods = this.getPropertyMethods(args);
            if (propertyMethods == 0) {
                return true;
            }
            int i = 0;
            while (i < propertyMethods) {
                if (this.isName((SimpleNode)args[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List<String> getBaseClassName(SimpleNode node) {
        ArrayList<String> bases = new ArrayList<String>();
        if (this.isClassDef(node)) {
            ClassDef clazz = (ClassDef)node;
            if (this.isFilledList((SimpleNode[])clazz.bases)) {
                exprType[] exprTypeArray = clazz.bases;
                int n = clazz.bases.length;
                int n2 = 0;
                while (n2 < n) {
                    exprType base = exprTypeArray[n2];
                    bases.add(this.getName((SimpleNode)base));
                    ++n2;
                }
            }
        }
        return bases;
    }

    public boolean hasSelfArgument(exprType[] args) {
        exprType[] exprTypeArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            exprType arg = exprTypeArray[n2];
            if (this.isSelf(this.getName((SimpleNode)arg))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isModule(SimpleNode node) {
        return node instanceof Module;
    }
}

