/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.refactoring.ast.FQIdentifier;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonModuleManager {
    private static final String INIT = "__init__.py";
    private IModulesManager moduleManager;
    private transient IPythonNature nature;
    public static boolean TESTING = false;

    public PythonModuleManager(IPythonNature nature) {
        this.nature = nature;
        this.moduleManager = nature.getAstManager().getModulesManager();
    }

    public Set<ModuleAdapter> resolveModule(File currentFile, FQIdentifier identifier) {
        if (identifier == null || currentFile == null || !currentFile.exists() || identifier.getProbableModuleName().length() == 0) {
            return new HashSet<ModuleAdapter>();
        }
        SortedMap<ModulesKey, ModulesKey> modulesStartingWith = this.resolveModules(identifier);
        return this.extractModuleAdapter(modulesStartingWith);
    }

    private Set<ModuleAdapter> extractModuleAdapter(SortedMap<ModulesKey, ModulesKey> modulesStartingWith) {
        HashSet<ModuleAdapter> resolvedModules = new HashSet<ModuleAdapter>();
        for (ModulesKey key : modulesStartingWith.keySet()) {
            try {
                ModuleAdapter moduleAdapter;
                if (key.file == null || (moduleAdapter = this.getModuleAdapterFromFile(key.file)) == null) continue;
                resolvedModules.add(moduleAdapter);
            }
            catch (Throwable throwable) {}
        }
        return resolvedModules;
    }

    private SortedMap<ModulesKey, ModulesKey> resolveModules(FQIdentifier identifier) {
        SortedMap modulesStartingWith = this.moduleManager.getAllModulesStartingWith(identifier.getProbableModuleName());
        if (modulesStartingWith.size() == 0) {
            modulesStartingWith = this.moduleManager.getAllModulesStartingWith(identifier.getModule());
        }
        return modulesStartingWith;
    }

    private ModuleAdapter getModuleAdapterFromFile(File file) throws Throwable {
        IDocument doc;
        if (file != null && !file.getName().equals(INIT) && file.exists() && (doc = PythonModuleManager.getDocFromFile(file)) != null && doc.getLength() > 0) {
            return VisitorFactory.createModuleAdapter(this, file, doc, this.nature);
        }
        return null;
    }

    public static IDocument getDocFromFile(File file) {
        boolean loadIfNotInWorkspace = true;
        if (TESTING) {
            loadIfNotInWorkspace = false;
        }
        IDocument doc = null;
        try {
            doc = REF.getDocFromFile((File)file, (boolean)loadIfNotInWorkspace);
        }
        catch (IOException iOException) {}
        if (doc == null) {
            try {
                doc = new Document(PythonModuleManager.getFileContent(new FileInputStream(file)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return doc;
    }

    private static String getFileContent(InputStream stream) {
        if (!TESTING) {
            throw new RuntimeException("Should only call this method in tests.");
        }
        try {
            String line;
            StringBuffer contentBuilder = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
            while ((line = bufferedReader.readLine()) != null) {
                contentBuilder.append(line).append('\n');
            }
            return contentBuilder.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public void setIModuleManager(IModulesManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public IModulesManager getIModuleManager() {
        return this.moduleManager;
    }
}

