/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.dltk.console.IScriptConsoleCommunication;
import org.python.pydev.dltk.console.IScriptConsoleInterpreter;
import org.python.pydev.dltk.console.InterpreterResponse;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.editor.codecompletion.templates.PyTemplateCompletionProcessor;
import org.python.pydev.editor.simpleassist.ISimpleAssistParticipant2;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsoleInterpreter
implements IScriptConsoleInterpreter {
    private IScriptConsoleCommunication consoleCommunication;
    private List<Runnable> closeRunnables = new ArrayList<Runnable>();
    private List<ISimpleAssistParticipant2> simpleParticipants;
    private List<IPythonNature> naturesUsed;

    public PydevConsoleInterpreter() {
        List p = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_simpleassist");
        ArrayList<ISimpleAssistParticipant2> list = new ArrayList<ISimpleAssistParticipant2>();
        for (Object o : p) {
            if (!(o instanceof ISimpleAssistParticipant2)) continue;
            list.add((ISimpleAssistParticipant2)o);
        }
        this.simpleParticipants = list;
    }

    public InterpreterResponse exec(String command) throws Exception {
        return this.consoleCommunication.execInterpreter(command);
    }

    public ICompletionProposal[] getCompletions(IScriptConsoleViewer viewer, String commandLine, int position, int offset, int whatToShow) throws Exception {
        String text = commandLine.substring(0, position);
        PySelection.ActivationTokenAndQual tokenAndQual = PySelection.getActivationTokenAndQual((IDocument)new Document(text), (int)text.length(), (boolean)true, (boolean)false);
        String actTok = tokenAndQual.activationToken;
        if (tokenAndQual.qualifier != null && tokenAndQual.qualifier.length() > 0) {
            if (actTok.length() > 0 && actTok.charAt(actTok.length() - 1) != '.') {
                actTok = new StringBuffer(String.valueOf(actTok)).append('.').toString();
            }
            actTok = new StringBuffer(String.valueOf(actTok)).append(tokenAndQual.qualifier).toString();
        }
        boolean showOnlyTemplates = whatToShow == 2;
        ArrayList results = new ArrayList();
        for (ISimpleAssistParticipant2 participant : this.simpleParticipants) {
            results.addAll(participant.computeConsoleProposals(tokenAndQual.activationToken, tokenAndQual.qualifier, offset));
        }
        ArrayList results2 = new ArrayList();
        if (!showOnlyTemplates) {
            ICompletionProposal[] consoleCompletions = this.consoleCommunication.getCompletions(actTok, offset);
            results2.addAll(Arrays.asList(consoleCompletions));
        }
        if (tokenAndQual.activationToken.length() == 0) {
            PyTemplateCompletionProcessor pyTemplateCompletionProcessor = new PyTemplateCompletionProcessor();
            pyTemplateCompletionProcessor.addTemplateProposals((ITextViewer)viewer, offset, results2);
            Collections.sort(results2, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        }
        ArrayList results3 = new ArrayList();
        if (!showOnlyTemplates) {
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
            for (Object participant : participants) {
                if (!(participant instanceof IPyDevCompletionParticipant2)) continue;
                IPyDevCompletionParticipant2 participant2 = (IPyDevCompletionParticipant2)participant;
                results3.addAll(participant2.computeConsoleCompletions(tokenAndQual, this.naturesUsed, viewer, offset));
            }
            Collections.sort(results3, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        }
        results.addAll(results2);
        results.addAll(results3);
        return results.toArray(new ICompletionProposal[0]);
    }

    public String getDescription(IDocument doc, int position) throws Exception {
        PySelection.ActivationTokenAndQual tokenAndQual = PySelection.getActivationTokenAndQual((IDocument)doc, (int)position, (boolean)true, (boolean)false);
        String actTok = tokenAndQual.activationToken;
        if (tokenAndQual.qualifier != null && tokenAndQual.qualifier.length() > 0) {
            if (actTok.length() > 0 && actTok.charAt(actTok.length() - 1) != '.') {
                actTok = new StringBuffer(String.valueOf(actTok)).append('.').toString();
            }
            actTok = new StringBuffer(String.valueOf(actTok)).append(tokenAndQual.qualifier).toString();
        }
        return this.consoleCommunication.getDescription(actTok);
    }

    public void close() {
        if (this.consoleCommunication != null) {
            try {
                this.consoleCommunication.close();
            }
            catch (Exception exception) {}
            this.consoleCommunication = null;
        }
        for (Runnable r : this.closeRunnables) {
            r.run();
        }
        this.closeRunnables = null;
    }

    public void setConsoleCommunication(IScriptConsoleCommunication protocol) {
        this.consoleCommunication = protocol;
    }

    public void addCloseOperation(Runnable runnable) {
        this.closeRunnables.add(runnable);
    }

    public void setNaturesUsed(List<IPythonNature> naturesUsed) {
        this.naturesUsed = naturesUsed;
    }
}

