/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.logging;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

public class PyLoggingPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String DEBUG_CODE_COMPLETION = "DEBUG_CODE_COMPLETION";
    public static final boolean DEFAULT_DEBUG_CODE_COMPLETION = false;
    public static final String DEBUG_ANALYSIS_REQUESTS = "DEBUG_ANALYSIS_REQUESTS";
    public static final boolean DEFAULT_DEBUG_ANALYSIS_REQUESTS = false;

    public PyLoggingPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor(DEBUG_CODE_COMPLETION, "Enable logging for code completion?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(DEBUG_ANALYSIS_REQUESTS, "Enable logging for analysis requests?", p));
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean isToDebugCodeCompletion() {
        if (PydevPlugin.getDefault() == null) {
            return false;
        }
        return PydevPrefs.getPreferences().getBoolean(DEBUG_CODE_COMPLETION);
    }

    public static boolean isToDebugAnalysisRequests() {
        if (PydevPlugin.getDefault() == null) {
            return false;
        }
        return PydevPrefs.getPreferences().getBoolean(DEBUG_ANALYSIS_REQUESTS);
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        DebugSettings.DEBUG_CODE_COMPLETION = PyLoggingPreferencesPage.isToDebugCodeCompletion();
        DebugSettings.DEBUG_ANALYSIS_REQUESTS = PyLoggingPreferencesPage.isToDebugAnalysisRequests();
        return ret;
    }
}

