/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.utils.LabelFieldEditor;

public class PyDevBuilderPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final boolean DEFAULT_USE_PYDEV_BUILDERS = true;
    public static final String USE_PYDEV_BUILDERS = "USE_PYDEV_BUILDERS";
    public static final boolean DEFAULT_USE_PYDEV_ONLY_ON_DOC_SAVE = false;
    public static final String USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE = "USE_PYDEV_ONLY_ON_DOC_SAVE";
    public static final int DEFAULT_PYDEV_ELAPSE_BEFORE_ANALYSIS = 3000;
    public static final String PYDEV_ELAPSE_BEFORE_ANALYSIS = "PYDEV_ELAPSE_BEFORE_ANALYSIS";
    public static final String ANALYZE_ONLY_ACTIVE_EDITOR = "ANALYZE_ONLY_ACTIVE_EDITOR";
    public static final boolean DEFAULT_ANALYZE_ONLY_ACTIVE_EDITOR = false;

    public PyDevBuilderPrefPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Pydev builders");
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        String s = "WARNING: \n\nPydev builders are required for many features \nprovided by Pydev such as:\n\n- Code completion\n- PyLint\n- TODO tasks\n\nSo, if you choose to disable it, note that the features \nmentioned above may not work as expected or may even not \nwork at all (use at your own risk).\n";
        this.addField(new LabelFieldEditor("LabelFieldEditor", s, p));
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYDEV_BUILDERS, "Use builders?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE, "Disable parser notifications?", p));
        this.addField((FieldEditor)new IntegerFieldEditor(PYDEV_ELAPSE_BEFORE_ANALYSIS, "Time to elapse before reparsing changed file (millis)", p));
        s = "If only open editors are analyzed, markers will only be added\nto the opened Pydev editors and will be removed upon close.\n";
        this.addField(new LabelFieldEditor("ActiveBufferLabelFieldEditor", s, p));
        this.addField((FieldEditor)new BooleanFieldEditor(ANALYZE_ONLY_ACTIVE_EDITOR, "Only analyze open editors?", p));
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean usePydevBuilders() {
        return PydevPrefs.getPreferences().getBoolean(USE_PYDEV_BUILDERS);
    }

    public static boolean useAnalysisOnlyOnDocSave() {
        return PyParserManager.getPyParserManager((Preferences)PydevPrefs.getPreferences()).useAnalysisOnlyOnDocSave();
    }

    public static boolean getAnalyzeOnlyActiveEditor() {
        return PydevPrefs.getPreferences().getBoolean(ANALYZE_ONLY_ACTIVE_EDITOR);
    }

    public static void setAnalyzeOnlyActiveEditor(boolean b) {
        PydevPrefs.getPreferences().setValue(ANALYZE_ONLY_ACTIVE_EDITOR, b);
    }

    public static int getElapseMillisBeforeAnalysis() {
        return PyParserManager.getPyParserManager((Preferences)PydevPrefs.getPreferences()).getElapseMillisBeforeAnalysis();
    }
}

